@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.AddonSrmPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a Site Recovery Manager (SRM) addon
 * @property addonType The type of private cloud addon
 * Expected value is 'SRM'.
 * @property licenseKey The Site Recovery Manager (SRM) license
 */
public data class AddonSrmPropertiesArgs(
    public val addonType: Output<String>,
    public val licenseKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.AddonSrmPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.AddonSrmPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.AddonSrmPropertiesArgs.builder()
            .addonType(addonType.applyValue({ args0 -> args0 }))
            .licenseKey(licenseKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonSrmPropertiesArgs].
 */
@PulumiTagMarker
public class AddonSrmPropertiesArgsBuilder internal constructor() {
    private var addonType: Output<String>? = null

    private var licenseKey: Output<String>? = null

    /**
     * @param value The type of private cloud addon
     * Expected value is 'SRM'.
     */
    @JvmName("eeyhrpqkhaehctbo")
    public suspend fun addonType(`value`: Output<String>) {
        this.addonType = value
    }

    /**
     * @param value The Site Recovery Manager (SRM) license
     */
    @JvmName("vyrnpslgdlakvjde")
    public suspend fun licenseKey(`value`: Output<String>) {
        this.licenseKey = value
    }

    /**
     * @param value The type of private cloud addon
     * Expected value is 'SRM'.
     */
    @JvmName("rrmaknphjgjdcwco")
    public suspend fun addonType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonType = mapped
    }

    /**
     * @param value The Site Recovery Manager (SRM) license
     */
    @JvmName("ixfgbyokdbvdueka")
    public suspend fun licenseKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseKey = mapped
    }

    internal fun build(): AddonSrmPropertiesArgs = AddonSrmPropertiesArgs(
        addonType = addonType ?: throw PulumiNullFieldException("addonType"),
        licenseKey = licenseKey,
    )
}
