@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.AvailabilityPropertiesArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.AvailabilityStrategy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties describing private cloud availability zone distribution
 * @property secondaryZone The secondary availability zone for the private cloud
 * @property strategy The availability strategy for the private cloud
 * @property zone The primary availability zone for the private cloud
 */
public data class AvailabilityPropertiesArgs(
    public val secondaryZone: Output<Int>? = null,
    public val strategy: Output<Either<String, AvailabilityStrategy>>? = null,
    public val zone: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.AvailabilityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.AvailabilityPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.AvailabilityPropertiesArgs.builder()
            .secondaryZone(secondaryZone?.applyValue({ args0 -> args0 }))
            .strategy(
                strategy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvailabilityPropertiesArgs].
 */
@PulumiTagMarker
public class AvailabilityPropertiesArgsBuilder internal constructor() {
    private var secondaryZone: Output<Int>? = null

    private var strategy: Output<Either<String, AvailabilityStrategy>>? = null

    private var zone: Output<Int>? = null

    /**
     * @param value The secondary availability zone for the private cloud
     */
    @JvmName("wedglfsquoauqdop")
    public suspend fun secondaryZone(`value`: Output<Int>) {
        this.secondaryZone = value
    }

    /**
     * @param value The availability strategy for the private cloud
     */
    @JvmName("tynnnbcfjxxlmqgj")
    public suspend fun strategy(`value`: Output<Either<String, AvailabilityStrategy>>) {
        this.strategy = value
    }

    /**
     * @param value The primary availability zone for the private cloud
     */
    @JvmName("ntwwmprkjmppsyvu")
    public suspend fun zone(`value`: Output<Int>) {
        this.zone = value
    }

    /**
     * @param value The secondary availability zone for the private cloud
     */
    @JvmName("sjidwogyoslvqlvn")
    public suspend fun secondaryZone(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryZone = mapped
    }

    /**
     * @param value The availability strategy for the private cloud
     */
    @JvmName("vjahrjovjljlypco")
    public suspend fun strategy(`value`: Either<String, AvailabilityStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value The availability strategy for the private cloud
     */
    @JvmName("ubpepcsaswyesyab")
    public fun strategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AvailabilityStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value The availability strategy for the private cloud
     */
    @JvmName("mdyposqdkpobahuw")
    public fun strategy(`value`: AvailabilityStrategy) {
        val toBeMapped = Either.ofRight<String, AvailabilityStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value The primary availability zone for the private cloud
     */
    @JvmName("ttdjoxjdooyshfgl")
    public suspend fun zone(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): AvailabilityPropertiesArgs = AvailabilityPropertiesArgs(
        secondaryZone = secondaryZone,
        strategy = strategy,
        zone = zone,
    )
}
