@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetScriptExecutionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scriptExecutionName Name of the user-invoked script execution resource
 */
public data class GetScriptExecutionPlainArgs(
    public val privateCloudName: String,
    public val resourceGroupName: String,
    public val scriptExecutionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetScriptExecutionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetScriptExecutionPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetScriptExecutionPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scriptExecutionName(scriptExecutionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScriptExecutionPlainArgs].
 */
@PulumiTagMarker
public class GetScriptExecutionPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    private var scriptExecutionName: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("eeffgtwysefrknpg")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tpmpbsgitxtfdhbc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the user-invoked script execution resource
     */
    @JvmName("bbwokafpiindxsrv")
    public suspend fun scriptExecutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scriptExecutionName = mapped
    }

    internal fun build(): GetScriptExecutionPlainArgs = GetScriptExecutionPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scriptExecutionName = scriptExecutionName ?: throw PulumiNullFieldException("scriptExecutionName"),
    )
}
