@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkSegmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property segmentId NSX Segment identifier. Generally the same as the Segment's display name
 */
public data class GetWorkloadNetworkSegmentPlainArgs(
    public val privateCloudName: String,
    public val resourceGroupName: String,
    public val segmentId: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkSegmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkSegmentPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkSegmentPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .segmentId(segmentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkSegmentPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkSegmentPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    private var segmentId: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("hvpauymcvilbmxht")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gcakmwvviismkmoe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX Segment identifier. Generally the same as the Segment's display name
     */
    @JvmName("xtuuhslieodyhyjd")
    public suspend fun segmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segmentId = mapped
    }

    internal fun build(): GetWorkloadNetworkSegmentPlainArgs = GetWorkloadNetworkSegmentPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        segmentId = segmentId ?: throw PulumiNullFieldException("segmentId"),
    )
}
