@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.ManagementClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a management cluster
 * @property clusterSize The cluster size
 * @property hosts The hosts
 */
public data class ManagementClusterArgs(
    public val clusterSize: Output<Int>,
    public val hosts: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.ManagementClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.ManagementClusterArgs =
        com.pulumi.azurenative.avs.inputs.ManagementClusterArgs.builder()
            .clusterSize(clusterSize.applyValue({ args0 -> args0 }))
            .hosts(hosts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ManagementClusterArgs].
 */
@PulumiTagMarker
public class ManagementClusterArgsBuilder internal constructor() {
    private var clusterSize: Output<Int>? = null

    private var hosts: Output<List<String>>? = null

    /**
     * @param value The cluster size
     */
    @JvmName("xtiluibsraphtmjr")
    public suspend fun clusterSize(`value`: Output<Int>) {
        this.clusterSize = value
    }

    /**
     * @param value The hosts
     */
    @JvmName("vybviauwtcpcvman")
    public suspend fun hosts(`value`: Output<List<String>>) {
        this.hosts = value
    }

    @JvmName("kqtwchanfqickjfx")
    public suspend fun hosts(vararg values: Output<String>) {
        this.hosts = Output.all(values.asList())
    }

    /**
     * @param values The hosts
     */
    @JvmName("ghnujeurwjxvyfhh")
    public suspend fun hosts(values: List<Output<String>>) {
        this.hosts = Output.all(values)
    }

    /**
     * @param value The cluster size
     */
    @JvmName("hfebvvelqkvrblwt")
    public suspend fun clusterSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSize = mapped
    }

    /**
     * @param value The hosts
     */
    @JvmName("eijppgxwruykdmlq")
    public suspend fun hosts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param values The hosts
     */
    @JvmName("lfdqkjywqjoipjai")
    public suspend fun hosts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    internal fun build(): ManagementClusterArgs = ManagementClusterArgs(
        clusterSize = clusterSize ?: throw PulumiNullFieldException("clusterSize"),
        hosts = hosts,
    )
}
