@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.PSCredentialExecutionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * a powershell credential object
 * @property name The parameter name
 * @property password password for login
 * @property type The type of execution parameter
 * Expected value is 'Credential'.
 * @property username username for login
 */
public data class PSCredentialExecutionParameterArgs(
    public val name: Output<String>,
    public val password: Output<String>? = null,
    public val type: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.PSCredentialExecutionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.PSCredentialExecutionParameterArgs =
        com.pulumi.azurenative.avs.inputs.PSCredentialExecutionParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PSCredentialExecutionParameterArgs].
 */
@PulumiTagMarker
public class PSCredentialExecutionParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The parameter name
     */
    @JvmName("htttmjwwycgqyqqk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value password for login
     */
    @JvmName("nchtikdpwpcnpuvg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'Credential'.
     */
    @JvmName("qixaovschkciniyy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value username for login
     */
    @JvmName("hdgfvnfwdfcottnu")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The parameter name
     */
    @JvmName("hcownicqpacemnil")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value password for login
     */
    @JvmName("wqlcbedmeushhavk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'Credential'.
     */
    @JvmName("xfpemqgrvdgcwkeb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value username for login
     */
    @JvmName("mywtoeyctvkvnskq")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): PSCredentialExecutionParameterArgs = PSCredentialExecutionParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
