@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.ScriptStringExecutionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * a plain text value execution parameter
 * @property name The parameter name
 * @property type The type of execution parameter
 * Expected value is 'Value'.
 * @property value The value for the passed parameter
 */
public data class ScriptStringExecutionParameterArgs(
    public val name: Output<String>,
    public val type: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.ScriptStringExecutionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.ScriptStringExecutionParameterArgs =
        com.pulumi.azurenative.avs.inputs.ScriptStringExecutionParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptStringExecutionParameterArgs].
 */
@PulumiTagMarker
public class ScriptStringExecutionParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The parameter name
     */
    @JvmName("dpeikagghrivxluc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'Value'.
     */
    @JvmName("glcuqejucqyjdtfc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value for the passed parameter
     */
    @JvmName("tcuiugqthhyblnqy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The parameter name
     */
    @JvmName("lqtekvtseadpkufy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'Value'.
     */
    @JvmName("qrwaosbsxawdrbhq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value for the passed parameter
     */
    @JvmName("kxomvauevheeoong")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ScriptStringExecutionParameterArgs = ScriptStringExecutionParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value`,
    )
}
