@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.VmVmPlacementPolicyPropertiesArgs.builder
import com.pulumi.azurenative.avs.kotlin.enums.AffinityType
import com.pulumi.azurenative.avs.kotlin.enums.PlacementPolicyState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VM-VM placement policy properties
 * @property affinityType placement policy affinity type
 * @property displayName Display name of the placement policy
 * @property state Whether the placement policy is enabled or disabled
 * @property type placement policy type
 * Expected value is 'VmVm'.
 * @property vmMembers Virtual machine members list
 */
public data class VmVmPlacementPolicyPropertiesArgs(
    public val affinityType: Output<Either<String, AffinityType>>,
    public val displayName: Output<String>? = null,
    public val state: Output<Either<String, PlacementPolicyState>>? = null,
    public val type: Output<String>,
    public val vmMembers: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.VmVmPlacementPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.VmVmPlacementPolicyPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.VmVmPlacementPolicyPropertiesArgs.builder()
            .affinityType(
                affinityType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .vmMembers(vmMembers.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VmVmPlacementPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class VmVmPlacementPolicyPropertiesArgsBuilder internal constructor() {
    private var affinityType: Output<Either<String, AffinityType>>? = null

    private var displayName: Output<String>? = null

    private var state: Output<Either<String, PlacementPolicyState>>? = null

    private var type: Output<String>? = null

    private var vmMembers: Output<List<String>>? = null

    /**
     * @param value placement policy affinity type
     */
    @JvmName("pnaepejwhjomjylk")
    public suspend fun affinityType(`value`: Output<Either<String, AffinityType>>) {
        this.affinityType = value
    }

    /**
     * @param value Display name of the placement policy
     */
    @JvmName("kocklddrnxdbjwhy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("jllkowryauobkxlt")
    public suspend fun state(`value`: Output<Either<String, PlacementPolicyState>>) {
        this.state = value
    }

    /**
     * @param value placement policy type
     * Expected value is 'VmVm'.
     */
    @JvmName("ushumriulqfmulwp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Virtual machine members list
     */
    @JvmName("kllhnkuqvyvrvhiv")
    public suspend fun vmMembers(`value`: Output<List<String>>) {
        this.vmMembers = value
    }

    @JvmName("smqywstbdtcvlfnv")
    public suspend fun vmMembers(vararg values: Output<String>) {
        this.vmMembers = Output.all(values.asList())
    }

    /**
     * @param values Virtual machine members list
     */
    @JvmName("cnobhoolhnjvdmfw")
    public suspend fun vmMembers(values: List<Output<String>>) {
        this.vmMembers = Output.all(values)
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("sqththwvpgupxjxd")
    public suspend fun affinityType(`value`: Either<String, AffinityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("ysxatakxympugugp")
    public fun affinityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AffinityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value placement policy affinity type
     */
    @JvmName("tnqprdkgsanpdnbq")
    public fun affinityType(`value`: AffinityType) {
        val toBeMapped = Either.ofRight<String, AffinityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.affinityType = mapped
    }

    /**
     * @param value Display name of the placement policy
     */
    @JvmName("qtgbsgymymsfoacd")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("okwjrsacqmeploiq")
    public suspend fun state(`value`: Either<String, PlacementPolicyState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("jsfjnfpqojwlvihi")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlacementPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Whether the placement policy is enabled or disabled
     */
    @JvmName("ogeletvchynllvpq")
    public fun state(`value`: PlacementPolicyState) {
        val toBeMapped = Either.ofRight<String, PlacementPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value placement policy type
     * Expected value is 'VmVm'.
     */
    @JvmName("rurriimvornasjnp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Virtual machine members list
     */
    @JvmName("ncvgvkurouppsyut")
    public suspend fun vmMembers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmMembers = mapped
    }

    /**
     * @param values Virtual machine members list
     */
    @JvmName("idumnxpqcufykbxe")
    public suspend fun vmMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmMembers = mapped
    }

    internal fun build(): VmVmPlacementPolicyPropertiesArgs = VmVmPlacementPolicyPropertiesArgs(
        affinityType = affinityType ?: throw PulumiNullFieldException("affinityType"),
        displayName = displayName,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        vmMembers = vmMembers ?: throw PulumiNullFieldException("vmMembers"),
    )
}
