@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Encryption Key
 * @property autoDetectedKeyVersion The auto-detected version of the key if versionType is auto-detected.
 * @property keyName The name of the key.
 * @property keyState The state of key provided
 * @property keyVaultUrl The URL of the vault.
 * @property keyVersion The version of the key.
 * @property versionType Property of the key if user provided or auto detected
 */
public data class EncryptionKeyVaultPropertiesResponse(
    public val autoDetectedKeyVersion: String,
    public val keyName: String? = null,
    public val keyState: String,
    public val keyVaultUrl: String? = null,
    public val keyVersion: String? = null,
    public val versionType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.EncryptionKeyVaultPropertiesResponse):
            EncryptionKeyVaultPropertiesResponse = EncryptionKeyVaultPropertiesResponse(
            autoDetectedKeyVersion = javaType.autoDetectedKeyVersion(),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyState = javaType.keyState(),
            keyVaultUrl = javaType.keyVaultUrl().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            versionType = javaType.versionType(),
        )
    }
}
