@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of customer managed encryption key
 * @property keyVaultProperties The key vault where the encryption key is stored
 * @property status Status of customer managed encryption key
 */
public data class EncryptionResponse(
    public val keyVaultProperties: EncryptionKeyVaultPropertiesResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.EncryptionResponse):
            EncryptionResponse = EncryptionResponse(
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.EncryptionKeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
