@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A cloud link resource
 * @property id Resource ID.
 * @property linkedCloud Identifier of the other private cloud participating in the link.
 * @property name Resource name.
 * @property status The state of the cloud link.
 * @property type Resource type.
 */
public data class GetCloudLinkResult(
    public val id: String,
    public val linkedCloud: String? = null,
    public val name: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetCloudLinkResult):
            GetCloudLinkResult = GetCloudLinkResult(
            id = javaType.id(),
            linkedCloud = javaType.linkedCloud().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
