@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A datastore resource
 * @property diskPoolVolume An iSCSI volume
 * @property id Resource ID.
 * @property name Resource name.
 * @property netAppVolume An Azure NetApp Files volume
 * @property provisioningState The state of the datastore provisioning
 * @property status The operational status of the datastore
 * @property type Resource type.
 */
public data class GetDatastoreResult(
    public val diskPoolVolume: DiskPoolVolumeResponse? = null,
    public val id: String,
    public val name: String,
    public val netAppVolume: NetAppVolumeResponse? = null,
    public val provisioningState: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetDatastoreResult):
            GetDatastoreResult = GetDatastoreResult(
            diskPoolVolume = javaType.diskPoolVolume().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.DiskPoolVolumeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            netAppVolume = javaType.netAppVolume().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.NetAppVolumeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
