@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs.builder
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.B2CResourceSKUArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.B2CResourceSKUArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * Other available API versions: 2019-01-01-preview, 2023-01-18-preview, 2023-05-17-preview.
 * ## Example Usage
 * ### Create tenant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var b2cTenant = new AzureNative.AzureActiveDirectory.B2CTenant("b2cTenant", new()
 *     {
 *         CountryCode = "US",
 *         DisplayName = "Contoso",
 *         Location = "United States",
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso.onmicrosoft.com",
 *         Sku = new AzureNative.AzureActiveDirectory.Inputs.B2CResourceSKUArgs
 *         {
 *             Name = AzureNative.AzureActiveDirectory.B2CResourceSKUName.Standard,
 *             Tier = AzureNative.AzureActiveDirectory.B2CResourceSKUTier.A0,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewB2CTenant(ctx, "b2cTenant", &azureactivedirectory.B2CTenantArgs{
 * 			CountryCode:       pulumi.String("US"),
 * 			DisplayName:       pulumi.String("Contoso"),
 * 			Location:          pulumi.String("United States"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso.onmicrosoft.com"),
 * 			Sku: &azureactivedirectory.B2CResourceSKUArgs{
 * 				Name: pulumi.String(azureactivedirectory.B2CResourceSKUNameStandard),
 * 				Tier: pulumi.String(azureactivedirectory.B2CResourceSKUTierA0),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.B2CTenant;
 * import com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs;
 * import com.pulumi.azurenative.azureactivedirectory.inputs.B2CResourceSKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var b2cTenant = new B2CTenant("b2cTenant", B2CTenantArgs.builder()
 *             .countryCode("US")
 *             .displayName("Contoso")
 *             .location("United States")
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso.onmicrosoft.com")
 *             .sku(B2CResourceSKUArgs.builder()
 *                 .name("Standard")
 *                 .tier("A0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:B2CTenant contoso.onmicrosoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/b2cDirectories/{resourceName}
 * ```
 * @property countryCode Country code of Azure tenant (e.g. 'US'). Refer to [aka&#46;ms/B2CDataResidency](https://aka.ms/B2CDataResidency) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
 * @property displayName The display name of the Azure AD B2C tenant.
 * @property location The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The initial domain name of the Azure AD B2C tenant.
 * @property sku SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
 * @property tags Resource Tags
 */
public data class B2CTenantArgs(
    public val countryCode: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<B2CResourceSKUArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs =
        com.pulumi.azurenative.azureactivedirectory.B2CTenantArgs.builder()
            .countryCode(countryCode?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [B2CTenantArgs].
 */
@PulumiTagMarker
public class B2CTenantArgsBuilder internal constructor() {
    private var countryCode: Output<String>? = null

    private var displayName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<B2CResourceSKUArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Country code of Azure tenant (e.g. 'US'). Refer to [aka&#46;ms/B2CDataResidency](https://aka.ms/B2CDataResidency) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
     */
    @JvmName("wssojdopsiffvaid")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The display name of the Azure AD B2C tenant.
     */
    @JvmName("hbenepwjcnlrckbd")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
     */
    @JvmName("wtoucwtsrsbqyctk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oblbkedbmjaioxry")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The initial domain name of the Azure AD B2C tenant.
     */
    @JvmName("atjrbivtecnvryvr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
     */
    @JvmName("ttuueqgkbxepsihh")
    public suspend fun sku(`value`: Output<B2CResourceSKUArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("xgogrmgiphiqgino")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Country code of Azure tenant (e.g. 'US'). Refer to [aka&#46;ms/B2CDataResidency](https://aka.ms/B2CDataResidency) to see valid country codes and corresponding data residency locations. If you do not see a country code in an valid data residency location, choose one from the list.
     */
    @JvmName("hnyhhqbkuupeqsck")
    public suspend fun countryCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The display name of the Azure AD B2C tenant.
     */
    @JvmName("lkvcoltbnowmkske")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
     */
    @JvmName("nxrdouospwqwdusp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ctdfruvrpcwllsby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The initial domain name of the Azure AD B2C tenant.
     */
    @JvmName("rldjmwflttvtcjkg")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
     */
    @JvmName("qwqtyiowqoiotkcf")
    public suspend fun sku(`value`: B2CResourceSKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cBilling).
     */
    @JvmName("emsgykkgsijfjnqb")
    public suspend fun sku(argument: suspend B2CResourceSKUArgsBuilder.() -> Unit) {
        val toBeMapped = B2CResourceSKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("ihxmryfqlcbfjlax")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource Tags
     */
    @JvmName("qgswovsrtkuecubu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): B2CTenantArgs = B2CTenantArgs(
        countryCode = countryCode,
        displayName = displayName,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
