@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CIAMResourceSKUResponse
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CreateCIAMTenantPropertiesResponse
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CIAMResourceSKUResponse.Companion.toKotlin as cIAMResourceSKUResponseToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.CreateCIAMTenantPropertiesResponse.Companion.toKotlin as createCIAMTenantPropertiesResponseToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CIAMTenant].
 */
@PulumiTagMarker
public class CIAMTenantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CIAMTenantArgs = CIAMTenantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CIAMTenantArgsBuilder.() -> Unit) {
        val builder = CIAMTenantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CIAMTenant {
        val builtJavaResource =
            com.pulumi.azurenative.azureactivedirectory.CIAMTenant(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CIAMTenant(builtJavaResource)
    }
}

/**
 * The Azure AD for customers resource.
 * Azure REST API version: 2023-05-17-preview.
 * ## Example Usage
 * ### Create_CIAM_tenant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ciamTenant = new AzureNative.AzureActiveDirectory.CIAMTenant("ciamTenant", new()
 *     {
 *         CreateTenantProperties = new AzureNative.AzureActiveDirectory.Inputs.CreateCIAMTenantPropertiesArgs
 *         {
 *             CountryCode = "US",
 *             DisplayName = "Contoso",
 *         },
 *         Location = "United States",
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso",
 *         Sku = new AzureNative.AzureActiveDirectory.Inputs.CIAMResourceSKUArgs
 *         {
 *             Name = AzureNative.AzureActiveDirectory.CIAMResourceSKUName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewCIAMTenant(ctx, "ciamTenant", &azureactivedirectory.CIAMTenantArgs{
 * 			CreateTenantProperties: &azureactivedirectory.CreateCIAMTenantPropertiesArgs{
 * 				CountryCode: pulumi.String("US"),
 * 				DisplayName: pulumi.String("Contoso"),
 * 			},
 * 			Location:          pulumi.String("United States"),
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso"),
 * 			Sku: &azureactivedirectory.CIAMResourceSKUArgs{
 * 				Name: pulumi.String(azureactivedirectory.CIAMResourceSKUNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.CIAMTenant;
 * import com.pulumi.azurenative.azureactivedirectory.CIAMTenantArgs;
 * import com.pulumi.azurenative.azureactivedirectory.inputs.CreateCIAMTenantPropertiesArgs;
 * import com.pulumi.azurenative.azureactivedirectory.inputs.CIAMResourceSKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ciamTenant = new CIAMTenant("ciamTenant", CIAMTenantArgs.builder()
 *             .createTenantProperties(CreateCIAMTenantPropertiesArgs.builder()
 *                 .countryCode("US")
 *                 .displayName("Contoso")
 *                 .build())
 *             .location("United States")
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso")
 *             .sku(CIAMResourceSKUArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:CIAMTenant contoso /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/ciamDirectories/{resourceName}
 * ```
 */
public class CIAMTenant internal constructor(
    override val javaResource: com.pulumi.azurenative.azureactivedirectory.CIAMTenant,
) : KotlinCustomResource(javaResource, CIAMTenantMapper) {
    /**
     * The type of billing. Will be MAU for all new customers. Cannot be changed if value is 'MAU'. Learn more about Azure AD for customers billing at [aka&#46;ms/b2cBilling](https://aka.ms/b2cbilling).
     */
    public val billingType: Output<String>
        get() = javaResource.billingType().applyValue({ args0 -> args0 })

    /**
     * These properties are used to create the Azure AD for customers tenant. These properties are not part of the Azure resource.
     */
    public val createTenantProperties: Output<CreateCIAMTenantPropertiesResponse>
        get() = javaResource.createTenantProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                createCIAMTenantPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The domain name of the tenant
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The data from which the billing type took effect
     */
    public val effectiveStartDateUtc: Output<String>
        get() = javaResource.effectiveStartDateUtc().applyValue({ args0 -> args0 })

    /**
     * The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/ciam-data-location) for more information.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the Azure AD for customers tenant resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
     */
    public val sku: Output<CIAMResourceSKUResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                cIAMResourceSKUResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource Tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * An identifier of the Azure AD for customers tenant.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the Azure AD for customers tenant resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CIAMTenantMapper : ResourceMapper<CIAMTenant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azureactivedirectory.CIAMTenant::class == javaResource::class

    override fun map(javaResource: Resource): CIAMTenant = CIAMTenant(
        javaResource as
            com.pulumi.azurenative.azureactivedirectory.CIAMTenant,
    )
}

/**
 * @see [CIAMTenant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CIAMTenant].
 */
public suspend fun ciamTenant(name: String, block: suspend CIAMTenantResourceBuilder.() -> Unit):
    CIAMTenant {
    val builder = CIAMTenantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CIAMTenant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ciamTenant(name: String): CIAMTenant {
    val builder = CIAMTenantResourceBuilder()
    builder.name(name)
    return builder.build()
}
