@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GuestUsage].
 */
@PulumiTagMarker
public class GuestUsageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GuestUsageArgs = GuestUsageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GuestUsageArgsBuilder.() -> Unit) {
        val builder = GuestUsageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GuestUsage {
        val builtJavaResource =
            com.pulumi.azurenative.azureactivedirectory.GuestUsage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GuestUsage(builtJavaResource)
    }
}

/**
 * Guest Usages Resource
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * Other available API versions: 2023-01-18-preview, 2023-05-17-preview.
 * ## Example Usage
 * ### GuestUsages_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestUsage = new AzureNative.AzureActiveDirectory.GuestUsage("guestUsage", new()
 *     {
 *         ResourceGroupName = "contosoResourceGroup",
 *         ResourceName = "contoso.onmicrosoft.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azureactivedirectory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azureactivedirectory.NewGuestUsage(ctx, "guestUsage", &azureactivedirectory.GuestUsageArgs{
 * 			ResourceGroupName: pulumi.String("contosoResourceGroup"),
 * 			ResourceName:      pulumi.String("contoso.onmicrosoft.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azureactivedirectory.GuestUsage;
 * import com.pulumi.azurenative.azureactivedirectory.GuestUsageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestUsage = new GuestUsage("guestUsage", GuestUsageArgs.builder()
 *             .resourceGroupName("contosoResourceGroup")
 *             .resourceName("contoso.onmicrosoft.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azureactivedirectory:GuestUsage contoso.onmicrosoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureActiveDirectory/guestUsages/{resourceName}
 * ```
 */
public class GuestUsage internal constructor(
    override val javaResource: com.pulumi.azurenative.azureactivedirectory.GuestUsage,
) : KotlinCustomResource(javaResource, GuestUsageMapper) {
    /**
     * Location of the Guest Usages resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the Guest Usages resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Key-value pairs of additional resource provisioning properties.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * An identifier for the tenant for which the resource is being created
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the Guest Usages resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GuestUsageMapper : ResourceMapper<GuestUsage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azureactivedirectory.GuestUsage::class == javaResource::class

    override fun map(javaResource: Resource): GuestUsage = GuestUsage(
        javaResource as
            com.pulumi.azurenative.azureactivedirectory.GuestUsage,
    )
}

/**
 * @see [GuestUsage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GuestUsage].
 */
public suspend fun guestUsage(name: String, block: suspend GuestUsageResourceBuilder.() -> Unit):
    GuestUsage {
    val builder = GuestUsageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GuestUsage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun guestUsage(name: String): GuestUsage {
    val builder = GuestUsageResourceBuilder()
    builder.name(name)
    return builder.build()
}
