@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The name of the SKU for the tenant.
 */
public enum class B2CResourceSKUName(
    public val javaValue: com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName> {
    /**
     * Azure AD B2C usage is billed to a linked Azure subscription and uses a monthly active users (MAU) billing model.
     */
    Standard(com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName.Standard),

    /**
     * Azure AD B2C usage is billed to a linked Azure subscription and uses number of authentications based billing.
     */
    PremiumP1(com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName.PremiumP1),

    /**
     * Azure AD B2C usage is billed to a linked Azure subscription and uses number of authentications based billing.
     */
    PremiumP2(com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName.PremiumP2),
    ;

    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azureactivedirectory.enums.B2CResourceSKUName):
            B2CResourceSKUName = B2CResourceSKUName.values().first { it.javaValue == javaType }
    }
}
