@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.inputs

import com.pulumi.azurenative.azureactivedirectory.inputs.CIAMResourceSKUArgs.builder
import com.pulumi.azurenative.azureactivedirectory.kotlin.enums.CIAMResourceSKUName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU properties of the Azure AD for customers tenant. Learn more about Azure AD for customers billing at [https://aka&#46;ms/ciambilling](https://aka.ms/ciambilling).
 * @property name The name of the SKU for the tenant.
 */
public data class CIAMResourceSKUArgs(
    public val name: Output<Either<String, CIAMResourceSKUName>>,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.inputs.CIAMResourceSKUArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.inputs.CIAMResourceSKUArgs =
        com.pulumi.azurenative.azureactivedirectory.inputs.CIAMResourceSKUArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CIAMResourceSKUArgs].
 */
@PulumiTagMarker
public class CIAMResourceSKUArgsBuilder internal constructor() {
    private var name: Output<Either<String, CIAMResourceSKUName>>? = null

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("xfdgrjoochcrqebb")
    public suspend fun name(`value`: Output<Either<String, CIAMResourceSKUName>>) {
        this.name = value
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("hiychmplacofkeys")
    public suspend fun name(`value`: Either<String, CIAMResourceSKUName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("frmdexemfnvhexin")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CIAMResourceSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for the tenant.
     */
    @JvmName("wkoegvvssexvqgud")
    public fun name(`value`: CIAMResourceSKUName) {
        val toBeMapped = Either.ofRight<String, CIAMResourceSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CIAMResourceSKUArgs = CIAMResourceSKUArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
