@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryConnectorPropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryConnectorPropertiesResponse.Companion.toKotlin as activeDirectoryConnectorPropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ActiveDirectoryConnector].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActiveDirectoryConnectorArgs = ActiveDirectoryConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActiveDirectoryConnectorArgsBuilder.() -> Unit) {
        val builder = ActiveDirectoryConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ActiveDirectoryConnector {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ActiveDirectoryConnector(builtJavaResource)
    }
}

/**
 * Active directory connector resource
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2022-03-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update an Active Directory connector instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activeDirectoryConnector = new AzureNative.AzureArcData.ActiveDirectoryConnector("activeDirectoryConnector", new()
 *     {
 *         ActiveDirectoryConnectorName = "testADConnector",
 *         DataControllerName = "testdataController",
 *         Properties = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorPropertiesArgs
 *         {
 *             Spec = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorSpecArgs
 *             {
 *                 ActiveDirectory = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorDomainDetailsArgs
 *                 {
 *                     DomainControllers = new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllersArgs
 *                     {
 *                         PrimaryDomainController = new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                         {
 *                             Hostname = "dc1.contoso.local",
 *                         },
 *                         SecondaryDomainControllers = new[]
 *                         {
 *                             new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                             {
 *                                 Hostname = "dc2.contoso.local",
 *                             },
 *                             new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                             {
 *                                 Hostname = "dc3.contoso.local",
 *                             },
 *                         },
 *                     },
 *                     Realm = "CONTOSO.LOCAL",
 *                     ServiceAccountProvisioning = AzureNative.AzureArcData.AccountProvisioningMode.Manual,
 *                 },
 *                 Dns = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorDNSDetailsArgs
 *                 {
 *                     NameserverIPAddresses = new[]
 *                     {
 *                         "11.11.111.111",
 *                         "22.22.222.222",
 *                     },
 *                     PreferK8sDnsForPtrLookups = false,
 *                     Replicas = 1,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewActiveDirectoryConnector(ctx, "activeDirectoryConnector", &azurearcdata.ActiveDirectoryConnectorArgs{
 * 			ActiveDirectoryConnectorName: pulumi.String("testADConnector"),
 * 			DataControllerName:           pulumi.String("testdataController"),
 * 			Properties: &azurearcdata.ActiveDirectoryConnectorPropertiesArgs{
 * 				Spec: &azurearcdata.ActiveDirectoryConnectorSpecArgs{
 * 					ActiveDirectory: &azurearcdata.ActiveDirectoryConnectorDomainDetailsArgs{
 * 						DomainControllers: &azurearcdata.ActiveDirectoryDomainControllersArgs{
 * 							PrimaryDomainController: &azurearcdata.ActiveDirectoryDomainControllerArgs{
 * 								Hostname: pulumi.String("dc1.contoso.local"),
 * 							},
 * 							SecondaryDomainControllers: azurearcdata.ActiveDirectoryDomainControllerArray{
 * 								&azurearcdata.ActiveDirectoryDomainControllerArgs{
 * 									Hostname: pulumi.String("dc2.contoso.local"),
 * 								},
 * 								&azurearcdata.ActiveDirectoryDomainControllerArgs{
 * 									Hostname: pulumi.String("dc3.contoso.local"),
 * 								},
 * 							},
 * 						},
 * 						Realm:                      pulumi.String("CONTOSO.LOCAL"),
 * 						ServiceAccountProvisioning: pulumi.String(azurearcdata.AccountProvisioningModeManual),
 * 					},
 * 					Dns: &azurearcdata.ActiveDirectoryConnectorDNSDetailsArgs{
 * 						NameserverIPAddresses: pulumi.StringArray{
 * 							pulumi.String("11.11.111.111"),
 * 							pulumi.String("22.22.222.222"),
 * 						},
 * 						PreferK8sDnsForPtrLookups: pulumi.Bool(false),
 * 						Replicas:                  pulumi.Float64(1),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector;
 * import com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorPropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorSpecArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDomainDetailsArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllersArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllerArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDNSDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activeDirectoryConnector = new ActiveDirectoryConnector("activeDirectoryConnector", ActiveDirectoryConnectorArgs.builder()
 *             .activeDirectoryConnectorName("testADConnector")
 *             .dataControllerName("testdataController")
 *             .properties(ActiveDirectoryConnectorPropertiesArgs.builder()
 *                 .spec(ActiveDirectoryConnectorSpecArgs.builder()
 *                     .activeDirectory(ActiveDirectoryConnectorDomainDetailsArgs.builder()
 *                         .domainControllers(ActiveDirectoryDomainControllersArgs.builder()
 *                             .primaryDomainController(ActiveDirectoryDomainControllerArgs.builder()
 *                                 .hostname("dc1.contoso.local")
 *                                 .build())
 *                             .secondaryDomainControllers(
 *                                 ActiveDirectoryDomainControllerArgs.builder()
 *                                     .hostname("dc2.contoso.local")
 *                                     .build(),
 *                                 ActiveDirectoryDomainControllerArgs.builder()
 *                                     .hostname("dc3.contoso.local")
 *                                     .build())
 *                             .build())
 *                         .realm("CONTOSO.LOCAL")
 *                         .serviceAccountProvisioning("manual")
 *                         .build())
 *                     .dns(ActiveDirectoryConnectorDNSDetailsArgs.builder()
 *                         .nameserverIPAddresses(
 *                             "11.11.111.111",
 *                             "22.22.222.222")
 *                         .preferK8sDnsForPtrLookups(false)
 *                         .replicas(1)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:ActiveDirectoryConnector testADConnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}/activeDirectoryConnectors/{activeDirectoryConnectorName}
 * ```
 */
public class ActiveDirectoryConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector,
) : KotlinCustomResource(javaResource, ActiveDirectoryConnectorMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<ActiveDirectoryConnectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                activeDirectoryConnectorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ActiveDirectoryConnectorMapper : ResourceMapper<ActiveDirectoryConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector::class == javaResource::class

    override fun map(javaResource: Resource): ActiveDirectoryConnector =
        ActiveDirectoryConnector(
            javaResource as
                com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector,
        )
}

/**
 * @see [ActiveDirectoryConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActiveDirectoryConnector].
 */
public suspend fun activeDirectoryConnector(
    name: String,
    block: suspend ActiveDirectoryConnectorResourceBuilder.() -> Unit,
): ActiveDirectoryConnector {
    val builder = ActiveDirectoryConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActiveDirectoryConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activeDirectoryConnector(name: String): ActiveDirectoryConnector {
    val builder = ActiveDirectoryConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
