@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.DataControllerArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.DataControllerPropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.DataControllerPropertiesArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Data controller resource
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update a Data Controller.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataController = new AzureNative.AzureArcData.DataController("dataController", new()
 *     {
 *         DataControllerName = "testdataController",
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = AzureNative.AzureArcData.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.DataControllerPropertiesArgs
 *         {
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             ClusterId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s",
 *             ExtensionId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension",
 *             Infrastructure = AzureNative.AzureArcData.Infrastructure.Onpremises,
 *             LogAnalyticsWorkspaceConfig = new AzureNative.AzureArcData.Inputs.LogAnalyticsWorkspaceConfigArgs
 *             {
 *                 PrimaryKey = "********",
 *                 WorkspaceId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             LogsDashboardCredential = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             MetricsDashboardCredential = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             OnPremiseProperty = new AzureNative.AzureArcData.Inputs.OnPremisePropertyArgs
 *             {
 *                 Id = "12345678-1234-1234-ab12-1a2b3c4d5e6f",
 *                 PublicSigningKey = "publicOnPremSigningKey",
 *             },
 *             UploadServicePrincipal = new AzureNative.AzureArcData.Inputs.UploadServicePrincipalArgs
 *             {
 *                 Authority = "https://login.microsoftonline.com/",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 ClientSecret = "********",
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             UploadWatermark = new AzureNative.AzureArcData.Inputs.UploadWatermarkArgs
 *             {
 *                 Logs = "2020-01-01T17:18:19.1234567Z",
 *                 Metrics = "2020-01-01T17:18:19.1234567Z",
 *                 Usages = "2020-01-01T17:18:19.1234567Z",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewDataController(ctx, "dataController", &azurearcdata.DataControllerArgs{
 * 			DataControllerName: pulumi.String("testdataController"),
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String(azurearcdata.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location: pulumi.String("northeurope"),
 * 			Properties: &azurearcdata.DataControllerPropertiesArgs{
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				ClusterId:      pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 * 				ExtensionId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 * 				Infrastructure: azurearcdata.InfrastructureOnpremises,
 * 				LogAnalyticsWorkspaceConfig: &azurearcdata.LogAnalyticsWorkspaceConfigArgs{
 * 					PrimaryKey:  pulumi.String("********"),
 * 					WorkspaceId: pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 				},
 * 				LogsDashboardCredential: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				MetricsDashboardCredential: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				OnPremiseProperty: &azurearcdata.OnPremisePropertyArgs{
 * 					Id:               pulumi.String("12345678-1234-1234-ab12-1a2b3c4d5e6f"),
 * 					PublicSigningKey: pulumi.String("publicOnPremSigningKey"),
 * 				},
 * 				UploadServicePrincipal: &azurearcdata.UploadServicePrincipalArgs{
 * 					Authority:    pulumi.String("https://login.microsoftonline.com/"),
 * 					ClientId:     pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 					ClientSecret: pulumi.String("********"),
 * 					TenantId:     pulumi.String("00000000-1111-2222-3333-444444444444"),
 * 				},
 * 				UploadWatermark: &azurearcdata.UploadWatermarkArgs{
 * 					Logs:    pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 					Metrics: pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 					Usages:  pulumi.String("2020-01-01T17:18:19.1234567Z"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.DataController;
 * import com.pulumi.azurenative.azurearcdata.DataControllerArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.DataControllerPropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.LogAnalyticsWorkspaceConfigArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.OnPremisePropertyArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.UploadServicePrincipalArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.UploadWatermarkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataController = new DataController("dataController", DataControllerArgs.builder()
 *             .dataControllerName("testdataController")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("northeurope")
 *             .properties(DataControllerPropertiesArgs.builder()
 *                 .basicLoginInformation(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .clusterId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s")
 *                 .extensionId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension")
 *                 .infrastructure("onpremises")
 *                 .logAnalyticsWorkspaceConfig(LogAnalyticsWorkspaceConfigArgs.builder()
 *                     .primaryKey("********")
 *                     .workspaceId("00000000-1111-2222-3333-444444444444")
 *                     .build())
 *                 .logsDashboardCredential(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .metricsDashboardCredential(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .onPremiseProperty(OnPremisePropertyArgs.builder()
 *                     .id("12345678-1234-1234-ab12-1a2b3c4d5e6f")
 *                     .publicSigningKey("publicOnPremSigningKey")
 *                     .build())
 *                 .uploadServicePrincipal(UploadServicePrincipalArgs.builder()
 *                     .authority("https://login.microsoftonline.com/")
 *                     .clientId("00000000-1111-2222-3333-444444444444")
 *                     .clientSecret("********")
 *                     .tenantId("00000000-1111-2222-3333-444444444444")
 *                     .build())
 *                 .uploadWatermark(UploadWatermarkArgs.builder()
 *                     .logs("2020-01-01T17:18:19.1234567Z")
 *                     .metrics("2020-01-01T17:18:19.1234567Z")
 *                     .usages("2020-01-01T17:18:19.1234567Z")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:DataController testdataController /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}
 * ```
 * @property dataControllerName The name of the data controller
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property properties The data controller's properties
 * @property resourceGroupName The name of the Azure resource group
 * @property tags Resource tags.
 */
public data class DataControllerArgs(
    public val dataControllerName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<DataControllerPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.DataControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.DataControllerArgs =
        com.pulumi.azurenative.azurearcdata.DataControllerArgs.builder()
            .dataControllerName(dataControllerName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataControllerArgs].
 */
@PulumiTagMarker
public class DataControllerArgsBuilder internal constructor() {
    private var dataControllerName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<DataControllerPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the data controller
     */
    @JvmName("cybgyshcdbcgonvh")
    public suspend fun dataControllerName(`value`: Output<String>) {
        this.dataControllerName = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("hhdcpralxixosrmj")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yimxirieiueuuumf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The data controller's properties
     */
    @JvmName("forghkiuvegkuxhq")
    public suspend fun properties(`value`: Output<DataControllerPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("wexnnoblxqjrsjfv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ojgqopnipnqjqmkh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the data controller
     */
    @JvmName("jyvaxirxnlvhwano")
    public suspend fun dataControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataControllerName = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("thfjdojxahloqrij")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("wqomlvoxhehqgvbo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mevwinamoqxjwrli")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The data controller's properties
     */
    @JvmName("ujvwnittbhysmwgo")
    public suspend fun properties(`value`: DataControllerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The data controller's properties
     */
    @JvmName("krqjfklxrxmefevx")
    public suspend fun properties(argument: suspend DataControllerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataControllerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("xhybwuxdgvgsnepv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ttlatpobrirlagrc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ykmxkpcdkpiysdgs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataControllerArgs = DataControllerArgs(
        dataControllerName = dataControllerName,
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
