@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlManagedInstancePropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlManagedInstanceSkuResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlManagedInstancePropertiesResponse.Companion.toKotlin as sqlManagedInstancePropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlManagedInstanceSkuResponse.Companion.toKotlin as sqlManagedInstanceSkuResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlManagedInstance].
 */
@PulumiTagMarker
public class SqlManagedInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlManagedInstanceArgs = SqlManagedInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlManagedInstanceArgsBuilder.() -> Unit) {
        val builder = SqlManagedInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlManagedInstance {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.SqlManagedInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlManagedInstance(builtJavaResource)
    }
}

/**
 * A SqlManagedInstance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Create or update a SQL Managed Instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlManagedInstance = new AzureNative.AzureArcData.SqlManagedInstance("sqlManagedInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = AzureNative.AzureArcData.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlManagedInstancePropertiesArgs
 *         {
 *             ActiveDirectoryInformation = new AzureNative.AzureArcData.Inputs.ActiveDirectoryInformationArgs
 *             {
 *                 KeytabInformation = new AzureNative.AzureArcData.Inputs.KeytabInformationArgs
 *                 {
 *                     Keytab = "********",
 *                 },
 *             },
 *             Admin = "Admin user",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             ClusterId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s",
 *             EndTime = "Instance end time",
 *             ExtensionId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension",
 *             K8sRaw = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceK8sRawArgs
 *             {
 *                 Spec = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceK8sSpecArgs
 *                 {
 *                     Replicas = 1,
 *                     Scheduling = new AzureNative.AzureArcData.Inputs.K8sSchedulingArgs
 *                     {
 *                         Default = new AzureNative.AzureArcData.Inputs.K8sSchedulingOptionsArgs
 *                         {
 *                             Resources = new AzureNative.AzureArcData.Inputs.K8sResourceRequirementsArgs
 *                             {
 *                                 Limits =
 *                                 {
 *                                     { "additionalProperty", "additionalValue" },
 *                                     { "cpu", "1" },
 *                                     { "memory", "8Gi" },
 *                                 },
 *                                 Requests =
 *                                 {
 *                                     { "additionalProperty", "additionalValue" },
 *                                     { "cpu", "1" },
 *                                     { "memory", "8Gi" },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     Security = new AzureNative.AzureArcData.Inputs.K8sSecurityArgs
 *                     {
 *                         ActiveDirectory = new AzureNative.AzureArcData.Inputs.K8sActiveDirectoryArgs
 *                         {
 *                             AccountName = "Account name",
 *                             Connector = new AzureNative.AzureArcData.Inputs.K8sActiveDirectoryConnectorArgs
 *                             {
 *                                 Name = "Name of connector",
 *                                 Namespace = "Namespace of connector",
 *                             },
 *                             EncryptionTypes = new[]
 *                             {
 *                                 "Encryption type item1, Encryption type item2,...",
 *                             },
 *                             KeytabSecret = "Key tab secret of account",
 *                         },
 *                         AdminLoginSecret = "test-sql-login-secret",
 *                         ServiceCertificateSecret = "Service Certificate Secret",
 *                         TransparentDataEncryption = new AzureNative.AzureArcData.Inputs.K8stransparentDataEncryptionArgs
 *                         {
 *                             Mode = "SystemManaged",
 *                         },
 *                     },
 *                     Settings = new AzureNative.AzureArcData.Inputs.K8sSettingsArgs
 *                     {
 *                         Network = new AzureNative.AzureArcData.Inputs.K8sNetworkSettingsArgs
 *                         {
 *                             Forceencryption = 0,
 *                             Tlsciphers = "ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384",
 *                             Tlsprotocols = "1.2",
 *                         },
 *                     },
 *                 },
 *             },
 *             LicenseType = AzureNative.AzureArcData.ArcSqlManagedInstanceLicenseType.LicenseIncluded,
 *             StartTime = "Instance start time",
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = AzureNative.AzureArcData.SqlManagedInstanceSkuName.VCore,
 *             Tier = AzureNative.AzureArcData.SqlManagedInstanceSkuTier.GeneralPurpose,
 *         },
 *         SqlManagedInstanceName = "testsqlManagedInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlManagedInstance(ctx, "sqlManagedInstance", &azurearcdata.SqlManagedInstanceArgs{
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String(azurearcdata.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location: pulumi.String("northeurope"),
 * 			Properties: &azurearcdata.SqlManagedInstancePropertiesArgs{
 * 				ActiveDirectoryInformation: &azurearcdata.ActiveDirectoryInformationArgs{
 * 					KeytabInformation: &azurearcdata.KeytabInformationArgs{
 * 						Keytab: pulumi.String("********"),
 * 					},
 * 				},
 * 				Admin: pulumi.String("Admin user"),
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				ClusterId:   pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 * 				EndTime:     pulumi.String("Instance end time"),
 * 				ExtensionId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 * 				K8sRaw: &azurearcdata.SqlManagedInstanceK8sRawArgs{
 * 					Spec: &azurearcdata.SqlManagedInstanceK8sSpecArgs{
 * 						Replicas: pulumi.Int(1),
 * 						Scheduling: &azurearcdata.K8sSchedulingArgs{
 * 							Default: &azurearcdata.K8sSchedulingOptionsArgs{
 * 								Resources: &azurearcdata.K8sResourceRequirementsArgs{
 * 									Limits: pulumi.StringMap{
 * 										"additionalProperty": pulumi.String("additionalValue"),
 * 										"cpu":                pulumi.String("1"),
 * 										"memory":             pulumi.String("8Gi"),
 * 									},
 * 									Requests: pulumi.StringMap{
 * 										"additionalProperty": pulumi.String("additionalValue"),
 * 										"cpu":                pulumi.String("1"),
 * 										"memory":             pulumi.String("8Gi"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						Security: &azurearcdata.K8sSecurityArgs{
 * 							ActiveDirectory: &azurearcdata.K8sActiveDirectoryArgs{
 * 								AccountName: pulumi.String("Account name"),
 * 								Connector: &azurearcdata.K8sActiveDirectoryConnectorArgs{
 * 									Name:      pulumi.String("Name of connector"),
 * 									Namespace: pulumi.String("Namespace of connector"),
 * 								},
 * 								EncryptionTypes: pulumi.StringArray{
 * 									pulumi.String("Encryption type item1, Encryption type item2,..."),
 * 								},
 * 								KeytabSecret: pulumi.String("Key tab secret of account"),
 * 							},
 * 							AdminLoginSecret:         pulumi.String("test-sql-login-secret"),
 * 							ServiceCertificateSecret: pulumi.String("Service Certificate Secret"),
 * 							TransparentDataEncryption: &azurearcdata.K8stransparentDataEncryptionArgs{
 * 								Mode: pulumi.String("SystemManaged"),
 * 							},
 * 						},
 * 						Settings: &azurearcdata.K8sSettingsArgs{
 * 							Network: &azurearcdata.K8sNetworkSettingsArgs{
 * 								Forceencryption: pulumi.Int(0),
 * 								Tlsciphers:      pulumi.String("ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384"),
 * 								Tlsprotocols:    pulumi.String("1.2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				LicenseType: pulumi.String(azurearcdata.ArcSqlManagedInstanceLicenseTypeLicenseIncluded),
 * 				StartTime:   pulumi.String("Instance start time"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Sku: &azurearcdata.SqlManagedInstanceSkuArgs{
 * 				Dev:  pulumi.Bool(true),
 * 				Name: azurearcdata.SqlManagedInstanceSkuNameVCore,
 * 				Tier: azurearcdata.SqlManagedInstanceSkuTierGeneralPurpose,
 * 			},
 * 			SqlManagedInstanceName: pulumi.String("testsqlManagedInstance"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlManagedInstance;
 * import com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstancePropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.KeytabInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.BasicLoginInformationArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sRawArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sSpecArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingOptionsArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sResourceRequirementsArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sSecurityArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryConnectorArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8stransparentDataEncryptionArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sSettingsArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.K8sNetworkSettingsArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlManagedInstance = new SqlManagedInstance("sqlManagedInstance", SqlManagedInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("northeurope")
 *             .properties(SqlManagedInstancePropertiesArgs.builder()
 *                 .activeDirectoryInformation(ActiveDirectoryInformationArgs.builder()
 *                     .keytabInformation(KeytabInformationArgs.builder()
 *                         .keytab("********")
 *                         .build())
 *                     .build())
 *                 .admin("Admin user")
 *                 .basicLoginInformation(BasicLoginInformationArgs.builder()
 *                     .password("********")
 *                     .username("username")
 *                     .build())
 *                 .clusterId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s")
 *                 .endTime("Instance end time")
 *                 .extensionId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension")
 *                 .k8sRaw(SqlManagedInstanceK8sRawArgs.builder()
 *                     .spec(SqlManagedInstanceK8sSpecArgs.builder()
 *                         .replicas(1)
 *                         .scheduling(K8sSchedulingArgs.builder()
 *                             .default_(K8sSchedulingOptionsArgs.builder()
 *                                 .resources(K8sResourceRequirementsArgs.builder()
 *                                     .limits(Map.ofEntries(
 *                                         Map.entry("additionalProperty", "additionalValue"),
 *                                         Map.entry("cpu", "1"),
 *                                         Map.entry("memory", "8Gi")
 *                                     ))
 *                                     .requests(Map.ofEntries(
 *                                         Map.entry("additionalProperty", "additionalValue"),
 *                                         Map.entry("cpu", "1"),
 *                                         Map.entry("memory", "8Gi")
 *                                     ))
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .security(K8sSecurityArgs.builder()
 *                             .activeDirectory(K8sActiveDirectoryArgs.builder()
 *                                 .accountName("Account name")
 *                                 .connector(K8sActiveDirectoryConnectorArgs.builder()
 *                                     .name("Name of connector")
 *                                     .namespace("Namespace of connector")
 *                                     .build())
 *                                 .encryptionTypes("Encryption type item1, Encryption type item2,...")
 *                                 .keytabSecret("Key tab secret of account")
 *                                 .build())
 *                             .adminLoginSecret("test-sql-login-secret")
 *                             .serviceCertificateSecret("Service Certificate Secret")
 *                             .transparentDataEncryption(K8stransparentDataEncryptionArgs.builder()
 *                                 .mode("SystemManaged")
 *                                 .build())
 *                             .build())
 *                         .settings(K8sSettingsArgs.builder()
 *                             .network(K8sNetworkSettingsArgs.builder()
 *                                 .forceencryption(0)
 *                                 .tlsciphers("ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384")
 *                                 .tlsprotocols("1.2")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .licenseType("LicenseIncluded")
 *                 .startTime("Instance start time")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sku(SqlManagedInstanceSkuArgs.builder()
 *                 .dev(true)
 *                 .name("vCore")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .sqlManagedInstanceName("testsqlManagedInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlManagedInstance testsqlManagedInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlManagedInstances/{sqlManagedInstanceName}
 * ```
 */
public class SqlManagedInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.SqlManagedInstance,
) : KotlinCustomResource(javaResource, SqlManagedInstanceMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<SqlManagedInstancePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sqlManagedInstancePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Resource sku.
     */
    public val sku: Output<SqlManagedInstanceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sqlManagedInstanceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlManagedInstanceMapper : ResourceMapper<SqlManagedInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.SqlManagedInstance::class == javaResource::class

    override fun map(javaResource: Resource): SqlManagedInstance = SqlManagedInstance(
        javaResource as
            com.pulumi.azurenative.azurearcdata.SqlManagedInstance,
    )
}

/**
 * @see [SqlManagedInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlManagedInstance].
 */
public suspend fun sqlManagedInstance(
    name: String,
    block: suspend SqlManagedInstanceResourceBuilder.() -> Unit,
): SqlManagedInstance {
    val builder = SqlManagedInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlManagedInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlManagedInstance(name: String): SqlManagedInstance {
    val builder = SqlManagedInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
