@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroupArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlServerAvailabilityGroupResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Arc Sql Server Availability Group
 * Azure REST API version: 2024-01-01.
 * ## Example Usage
 * ### Create a Arc Sql Server availability group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerAvailabilityGroup = new AzureNative.AzureArcData.SqlServerAvailabilityGroup("sqlServerAvailabilityGroup", new()
 *     {
 *         AvailabilityGroupName = "testAG",
 *         Location = "southeastasia",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlServerAvailabilityGroupResourcePropertiesArgs
 *         {
 *             Databases = new AzureNative.AzureArcData.Inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     new AzureNative.AzureArcData.Inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs
 *                     {
 *                         DatabaseName = "db1",
 *                     },
 *                     new AzureNative.AzureArcData.Inputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs
 *                     {
 *                         DatabaseName = "db2",
 *                     },
 *                 },
 *             },
 *             Info = new AzureNative.AzureArcData.Inputs.AvailabilityGroupInfoArgs
 *             {
 *                 BasicFeatures = false,
 *                 DbFailover = true,
 *                 DtcSupport = false,
 *                 FailureConditionLevel = 3,
 *                 HealthCheckTimeout = 30000,
 *                 IsContained = false,
 *                 IsDistributed = false,
 *                 RequiredSynchronizedSecondariesToCommit = 0,
 *             },
 *             Replicas = new AzureNative.AzureArcData.Inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     new AzureNative.AzureArcData.Inputs.SqlAvailabilityGroupReplicaResourcePropertiesArgs
 *                     {
 *                         Configure = new AzureNative.AzureArcData.Inputs.AvailabilityGroupConfigureArgs
 *                         {
 *                             BackupPriority = 50,
 *                             EndpointUrl = "TCP://mytest60-0.mytest60-svc:5022",
 *                             SessionTimeout = 10,
 *                         },
 *                         ReplicaName = "testSqlServer\\INST1",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlServerInstanceName = "testSqlServer_INST1",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlServerAvailabilityGroup(ctx, "sqlServerAvailabilityGroup", &azurearcdata.SqlServerAvailabilityGroupArgs{
 * 			AvailabilityGroupName: pulumi.String("testAG"),
 * 			Location:              pulumi.String("southeastasia"),
 * 			Properties: &azurearcdata.SqlServerAvailabilityGroupResourcePropertiesArgs{
 * 				Databases: &azurearcdata.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs{
 * 					Value: azurearcdata.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArray{
 * 						&azurearcdata.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs{
 * 							DatabaseName: pulumi.String("db1"),
 * 						},
 * 						&azurearcdata.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs{
 * 							DatabaseName: pulumi.String("db2"),
 * 						},
 * 					},
 * 				},
 * 				Info: &azurearcdata.AvailabilityGroupInfoArgs{
 * 					BasicFeatures:                           pulumi.Bool(false),
 * 					DbFailover:                              pulumi.Bool(true),
 * 					DtcSupport:                              pulumi.Bool(false),
 * 					FailureConditionLevel:                   pulumi.Int(3),
 * 					HealthCheckTimeout:                      pulumi.Int(30000),
 * 					IsContained:                             pulumi.Bool(false),
 * 					IsDistributed:                           pulumi.Bool(false),
 * 					RequiredSynchronizedSecondariesToCommit: pulumi.Int(0),
 * 				},
 * 				Replicas: &azurearcdata.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs{
 * 					Value: azurearcdata.SqlAvailabilityGroupReplicaResourcePropertiesArray{
 * 						&azurearcdata.SqlAvailabilityGroupReplicaResourcePropertiesArgs{
 * 							Configure: &azurearcdata.AvailabilityGroupConfigureArgs{
 * 								BackupPriority: pulumi.Int(50),
 * 								EndpointUrl:    pulumi.String("TCP://mytest60-0.mytest60-svc:5022"),
 * 								SessionTimeout: pulumi.Int(10),
 * 							},
 * 							ReplicaName: pulumi.String("testSqlServer\\INST1"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlServerInstanceName: pulumi.String("testSqlServer_INST1"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroup;
 * import com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroupArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.AvailabilityGroupInfoArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerAvailabilityGroup = new SqlServerAvailabilityGroup("sqlServerAvailabilityGroup", SqlServerAvailabilityGroupArgs.builder()
 *             .availabilityGroupName("testAG")
 *             .location("southeastasia")
 *             .properties(SqlServerAvailabilityGroupResourcePropertiesArgs.builder()
 *                 .databases(SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs.builder()
 *                     .value(
 *                         SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs.builder()
 *                             .databaseName("db1")
 *                             .build(),
 *                         SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs.builder()
 *                             .databaseName("db2")
 *                             .build())
 *                     .build())
 *                 .info(AvailabilityGroupInfoArgs.builder()
 *                     .basicFeatures(false)
 *                     .dbFailover(true)
 *                     .dtcSupport(false)
 *                     .failureConditionLevel(3)
 *                     .healthCheckTimeout(30000)
 *                     .isContained(false)
 *                     .isDistributed(false)
 *                     .requiredSynchronizedSecondariesToCommit(0)
 *                     .build())
 *                 .replicas(SqlServerAvailabilityGroupResourcePropertiesReplicasArgs.builder()
 *                     .value(SqlAvailabilityGroupReplicaResourcePropertiesArgs.builder()
 *                         .configure(AvailabilityGroupConfigureArgs.builder()
 *                             .backupPriority(50)
 *                             .endpointUrl("TCP://mytest60-0.mytest60-svc:5022")
 *                             .sessionTimeout(10)
 *                             .build())
 *                         .replicaName("testSqlServer\\INST1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sqlServerInstanceName("testSqlServer_INST1")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlServerAvailabilityGroup testAG /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlServerInstances/{sqlServerInstanceName}/availabilityGroups/{availabilityGroupName}
 * ```
 * @property availabilityGroupName Name of SQL Availability Group
 * @property location The geo-location where the resource lives
 * @property properties Properties of Arc Sql Server availability group
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 * @property tags Resource tags.
 */
public data class SqlServerAvailabilityGroupArgs(
    public val availabilityGroupName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SqlServerAvailabilityGroupResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlServerInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroupArgs =
        com.pulumi.azurenative.azurearcdata.SqlServerAvailabilityGroupArgs.builder()
            .availabilityGroupName(availabilityGroupName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlServerAvailabilityGroupArgs].
 */
@PulumiTagMarker
public class SqlServerAvailabilityGroupArgsBuilder internal constructor() {
    private var availabilityGroupName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<SqlServerAvailabilityGroupResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlServerInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of SQL Availability Group
     */
    @JvmName("rcjjtwxtvqicqhec")
    public suspend fun availabilityGroupName(`value`: Output<String>) {
        this.availabilityGroupName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fordjnulmggqovvk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Arc Sql Server availability group
     */
    @JvmName("oydetvpbuuogtsbn")
    public suspend fun properties(`value`: Output<SqlServerAvailabilityGroupResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("kyqxyrmbwxcnhtux")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("ndohggyojbfbrwyh")
    public suspend fun sqlServerInstanceName(`value`: Output<String>) {
        this.sqlServerInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sgvpvrjdnkfajnhx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of SQL Availability Group
     */
    @JvmName("onemmpjltoqcqjqb")
    public suspend fun availabilityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityGroupName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jsmmxlvqcxxdbvxr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Arc Sql Server availability group
     */
    @JvmName("gkcqgaxcvdsfvujd")
    public suspend fun properties(`value`: SqlServerAvailabilityGroupResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Arc Sql Server availability group
     */
    @JvmName("ghiihyfjjbexhkbr")
    public suspend
    fun properties(argument: suspend SqlServerAvailabilityGroupResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerAvailabilityGroupResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("erqsksjdriowpdqe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("slnmavnyfqbnelhn")
    public suspend fun sqlServerInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iibdrngcrrbxgmnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qxcljlkptbbmhrew")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlServerAvailabilityGroupArgs = SqlServerAvailabilityGroupArgs(
        availabilityGroupName = availabilityGroupName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sqlServerInstanceName = sqlServerInstanceName,
        tags = tags,
    )
}
