@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerInstancePropertiesResponse
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerInstancePropertiesResponse.Companion.toKotlin as sqlServerInstancePropertiesResponseToKotlin
import com.pulumi.azurenative.azurearcdata.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlServerInstance].
 */
@PulumiTagMarker
public class SqlServerInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlServerInstanceArgs = SqlServerInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlServerInstanceArgsBuilder.() -> Unit) {
        val builder = SqlServerInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlServerInstance {
        val builtJavaResource =
            com.pulumi.azurenative.azurearcdata.SqlServerInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlServerInstance(builtJavaResource)
    }
}

/**
 * A SqlServerInstance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Updates a SQL Server Instance tags.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerInstance = new AzureNative.AzureArcData.SqlServerInstance("sqlServerInstance", new()
 *     {
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlServerInstancePropertiesArgs
 *         {
 *             AzureDefenderStatus = AzureNative.AzureArcData.DefenderStatus.Protected,
 *             AzureDefenderStatusLastUpdated = "2020-01-02T17:18:19.1234567Z",
 *             Collation = "collation",
 *             ContainerResourceId = "Resource id of hosting Arc Machine",
 *             Cores = "4",
 *             CurrentVersion = "2012",
 *             Edition = AzureNative.AzureArcData.EditionType.Developer,
 *             HostType = AzureNative.AzureArcData.HostType.Physical_Server,
 *             InstanceName = "name of instance",
 *             LicenseType = AzureNative.AzureArcData.ArcSqlServerLicenseType.Free,
 *             PatchLevel = "patchlevel",
 *             ProductId = "sql id",
 *             Status = AzureNative.AzureArcData.ConnectionStatus.Registered,
 *             TcpDynamicPorts = "1433",
 *             TcpStaticPorts = "1433",
 *             VCore = "4",
 *             Version = AzureNative.AzureArcData.SqlVersion.SQL_Server_2012,
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlServerInstanceName = "testsqlServerInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewSqlServerInstance(ctx, "sqlServerInstance", &azurearcdata.SqlServerInstanceArgs{
 * 			Location: pulumi.String("northeurope"),
 * 			Properties: &azurearcdata.SqlServerInstancePropertiesArgs{
 * 				AzureDefenderStatus:            pulumi.String(azurearcdata.DefenderStatusProtected),
 * 				AzureDefenderStatusLastUpdated: pulumi.String("2020-01-02T17:18:19.1234567Z"),
 * 				Collation:                      pulumi.String("collation"),
 * 				ContainerResourceId:            pulumi.String("Resource id of hosting Arc Machine"),
 * 				Cores:                          pulumi.String("4"),
 * 				CurrentVersion:                 pulumi.String("2012"),
 * 				Edition:                        pulumi.String(azurearcdata.EditionTypeDeveloper),
 * 				HostType:                       pulumi.String(azurearcdata.HostType_Physical_Server),
 * 				InstanceName:                   pulumi.String("name of instance"),
 * 				LicenseType:                    pulumi.String(azurearcdata.ArcSqlServerLicenseTypeFree),
 * 				PatchLevel:                     pulumi.String("patchlevel"),
 * 				ProductId:                      pulumi.String("sql id"),
 * 				Status:                         pulumi.String(azurearcdata.ConnectionStatusRegistered),
 * 				TcpDynamicPorts:                pulumi.String("1433"),
 * 				TcpStaticPorts:                 pulumi.String("1433"),
 * 				VCore:                          pulumi.String("4"),
 * 				Version:                        pulumi.String(azurearcdata.SqlVersion_SQL_Server_2012),
 * 			},
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlServerInstanceName: pulumi.String("testsqlServerInstance"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlServerInstance;
 * import com.pulumi.azurenative.azurearcdata.SqlServerInstanceArgs;
 * import com.pulumi.azurenative.azurearcdata.inputs.SqlServerInstancePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerInstance = new SqlServerInstance("sqlServerInstance", SqlServerInstanceArgs.builder()
 *             .location("northeurope")
 *             .properties(SqlServerInstancePropertiesArgs.builder()
 *                 .azureDefenderStatus("Protected")
 *                 .azureDefenderStatusLastUpdated("2020-01-02T17:18:19.1234567Z")
 *                 .collation("collation")
 *                 .containerResourceId("Resource id of hosting Arc Machine")
 *                 .cores("4")
 *                 .currentVersion("2012")
 *                 .edition("Developer")
 *                 .hostType("Physical Server")
 *                 .instanceName("name of instance")
 *                 .licenseType("Free")
 *                 .patchLevel("patchlevel")
 *                 .productId("sql id")
 *                 .status("Registered")
 *                 .tcpDynamicPorts("1433")
 *                 .tcpStaticPorts("1433")
 *                 .vCore("4")
 *                 .version("SQL Server 2012")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .sqlServerInstanceName("testsqlServerInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlServerInstance testsqlServerInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlServerInstances/{sqlServerInstanceName}
 * ```
 */
public class SqlServerInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.azurearcdata.SqlServerInstance,
) : KotlinCustomResource(javaResource, SqlServerInstanceMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * null
     */
    public val properties: Output<SqlServerInstancePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sqlServerInstancePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlServerInstanceMapper : ResourceMapper<SqlServerInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurearcdata.SqlServerInstance::class == javaResource::class

    override fun map(javaResource: Resource): SqlServerInstance = SqlServerInstance(
        javaResource as
            com.pulumi.azurenative.azurearcdata.SqlServerInstance,
    )
}

/**
 * @see [SqlServerInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlServerInstance].
 */
public suspend fun sqlServerInstance(
    name: String,
    block: suspend SqlServerInstanceResourceBuilder.() -> Unit,
): SqlServerInstance {
    val builder = SqlServerInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlServerInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlServerInstance(name: String): SqlServerInstance {
    val builder = SqlServerInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
