@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The aggregation type to use for the numerical columns in the dataset.
 */
public enum class AggregationType(
    public val javaValue: com.pulumi.azurenative.azurearcdata.enums.AggregationType,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.enums.AggregationType> {
    Average(com.pulumi.azurenative.azurearcdata.enums.AggregationType.Average),
    Minimum(com.pulumi.azurenative.azurearcdata.enums.AggregationType.Minimum),
    Maximum(com.pulumi.azurenative.azurearcdata.enums.AggregationType.Maximum),
    Sum(com.pulumi.azurenative.azurearcdata.enums.AggregationType.Sum),
    Count(com.pulumi.azurenative.azurearcdata.enums.AggregationType.Count),
    ;

    override fun toJava(): com.pulumi.azurenative.azurearcdata.enums.AggregationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.enums.AggregationType):
            AggregationType = AggregationType.values().first { it.javaValue == javaType }
    }
}
