@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of host for Azure Arc SQL Server
 */
public enum class HostType(
    public val javaValue: com.pulumi.azurenative.azurearcdata.enums.HostType,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.enums.HostType> {
    Azure_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.Azure_Virtual_Machine),
    Azure_VMWare_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.Azure_VMWare_Virtual_Machine),
    Azure_Kubernetes_Service(com.pulumi.azurenative.azurearcdata.enums.HostType.Azure_Kubernetes_Service),
    AWS_VMWare_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.AWS_VMWare_Virtual_Machine),
    AWS_Kubernetes_Service(com.pulumi.azurenative.azurearcdata.enums.HostType.AWS_Kubernetes_Service),
    GCP_VMWare_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.GCP_VMWare_Virtual_Machine),
    GCP_Kubernetes_Service(com.pulumi.azurenative.azurearcdata.enums.HostType.GCP_Kubernetes_Service),
    Container(com.pulumi.azurenative.azurearcdata.enums.HostType.Container),
    Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.Virtual_Machine),
    Physical_Server(com.pulumi.azurenative.azurearcdata.enums.HostType.Physical_Server),
    AWS_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.AWS_Virtual_Machine),
    GCP_Virtual_Machine(com.pulumi.azurenative.azurearcdata.enums.HostType.GCP_Virtual_Machine),
    Other(com.pulumi.azurenative.azurearcdata.enums.HostType.Other),
    ;

    override fun toJava(): com.pulumi.azurenative.azurearcdata.enums.HostType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.enums.HostType): HostType =
            HostType.values().first { it.javaValue == javaType }
    }
}
