@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDNSDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DNS server details
 * @property domainName DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
 * @property nameserverIPAddresses List of Active Directory DNS server IP addresses.
 * @property preferK8sDnsForPtrLookups Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
 * @property replicas Replica count for DNS proxy service. Default value is 1.
 */
public data class ActiveDirectoryConnectorDNSDetailsArgs(
    public val domainName: Output<String>? = null,
    public val nameserverIPAddresses: Output<List<String>>,
    public val preferK8sDnsForPtrLookups: Output<Boolean>? = null,
    public val replicas: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDNSDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDNSDetailsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorDNSDetailsArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .nameserverIPAddresses(nameserverIPAddresses.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .preferK8sDnsForPtrLookups(preferK8sDnsForPtrLookups?.applyValue({ args0 -> args0 }))
            .replicas(replicas?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryConnectorDNSDetailsArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorDNSDetailsArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var nameserverIPAddresses: Output<List<String>>? = null

    private var preferK8sDnsForPtrLookups: Output<Boolean>? = null

    private var replicas: Output<Double>? = null

    /**
     * @param value DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
     */
    @JvmName("qrpbrkeydtnugnol")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value List of Active Directory DNS server IP addresses.
     */
    @JvmName("ylfxrmwttyyhdxrv")
    public suspend fun nameserverIPAddresses(`value`: Output<List<String>>) {
        this.nameserverIPAddresses = value
    }

    @JvmName("qawagbqcfemrrkfp")
    public suspend fun nameserverIPAddresses(vararg values: Output<String>) {
        this.nameserverIPAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of Active Directory DNS server IP addresses.
     */
    @JvmName("gwmbaknphfgqysef")
    public suspend fun nameserverIPAddresses(values: List<Output<String>>) {
        this.nameserverIPAddresses = Output.all(values)
    }

    /**
     * @param value Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
     */
    @JvmName("nutmkcoxmybbdrai")
    public suspend fun preferK8sDnsForPtrLookups(`value`: Output<Boolean>) {
        this.preferK8sDnsForPtrLookups = value
    }

    /**
     * @param value Replica count for DNS proxy service. Default value is 1.
     */
    @JvmName("jxjhrwldsoobhdfm")
    public suspend fun replicas(`value`: Output<Double>) {
        this.replicas = value
    }

    /**
     * @param value DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
     */
    @JvmName("ndftirdjlcpoowwy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value List of Active Directory DNS server IP addresses.
     */
    @JvmName("toxcpcdgcjruxdyd")
    public suspend fun nameserverIPAddresses(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameserverIPAddresses = mapped
    }

    /**
     * @param values List of Active Directory DNS server IP addresses.
     */
    @JvmName("aumosrviyfefoisl")
    public suspend fun nameserverIPAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameserverIPAddresses = mapped
    }

    /**
     * @param value Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
     */
    @JvmName("cknoxmifylpgjgtm")
    public suspend fun preferK8sDnsForPtrLookups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferK8sDnsForPtrLookups = mapped
    }

    /**
     * @param value Replica count for DNS proxy service. Default value is 1.
     */
    @JvmName("mkrloqetrpxoeujv")
    public suspend fun replicas(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): ActiveDirectoryConnectorDNSDetailsArgs =
        ActiveDirectoryConnectorDNSDetailsArgs(
            domainName = domainName,
            nameserverIPAddresses = nameserverIPAddresses ?: throw
                PulumiNullFieldException("nameserverIPAddresses"),
            preferK8sDnsForPtrLookups = preferK8sDnsForPtrLookups,
            replicas = replicas,
        )
}
