@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a domain controller in the AD domain.
 * @property hostname Fully-qualified domain name of a domain controller in the AD domain.
 */
public data class ActiveDirectoryDomainControllerArgs(
    public val hostname: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllerArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllerArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllerArgs.builder()
            .hostname(hostname.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryDomainControllerArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryDomainControllerArgsBuilder internal constructor() {
    private var hostname: Output<String>? = null

    /**
     * @param value Fully-qualified domain name of a domain controller in the AD domain.
     */
    @JvmName("umtibfpukqdgefql")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Fully-qualified domain name of a domain controller in the AD domain.
     */
    @JvmName("ixxlnhammvlfucdh")
    public suspend fun hostname(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    internal fun build(): ActiveDirectoryDomainControllerArgs = ActiveDirectoryDomainControllerArgs(
        hostname = hostname ?: throw PulumiNullFieldException("hostname"),
    )
}
