@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details about the Active Directory domain controllers associated with this AD connector instance
 * @property primaryDomainController Information about the Primary Domain Controller (PDC) in the AD domain.
 * @property secondaryDomainControllers null
 */
public data class ActiveDirectoryDomainControllersArgs(
    public val primaryDomainController: Output<ActiveDirectoryDomainControllerArgs>? = null,
    public val secondaryDomainControllers: Output<List<ActiveDirectoryDomainControllerArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllersArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllersArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryDomainControllersArgs.builder()
            .primaryDomainController(
                primaryDomainController?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .secondaryDomainControllers(
                secondaryDomainControllers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActiveDirectoryDomainControllersArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryDomainControllersArgsBuilder internal constructor() {
    private var primaryDomainController: Output<ActiveDirectoryDomainControllerArgs>? = null

    private var secondaryDomainControllers: Output<List<ActiveDirectoryDomainControllerArgs>>? = null

    /**
     * @param value Information about the Primary Domain Controller (PDC) in the AD domain.
     */
    @JvmName("vttxfybpnmouylok")
    public suspend fun primaryDomainController(`value`: Output<ActiveDirectoryDomainControllerArgs>) {
        this.primaryDomainController = value
    }

    /**
     * @param value null
     */
    @JvmName("gafpeboajmdvtrpm")
    public suspend
    fun secondaryDomainControllers(`value`: Output<List<ActiveDirectoryDomainControllerArgs>>) {
        this.secondaryDomainControllers = value
    }

    @JvmName("kbptlcyjkvutggus")
    public suspend fun secondaryDomainControllers(
        vararg
        values: Output<ActiveDirectoryDomainControllerArgs>,
    ) {
        this.secondaryDomainControllers = Output.all(values.asList())
    }

    /**
     * @param values null
     */
    @JvmName("orhexwrlymgfaryl")
    public suspend
    fun secondaryDomainControllers(values: List<Output<ActiveDirectoryDomainControllerArgs>>) {
        this.secondaryDomainControllers = Output.all(values)
    }

    /**
     * @param value Information about the Primary Domain Controller (PDC) in the AD domain.
     */
    @JvmName("muecjnavehparyqk")
    public suspend fun primaryDomainController(`value`: ActiveDirectoryDomainControllerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryDomainController = mapped
    }

    /**
     * @param argument Information about the Primary Domain Controller (PDC) in the AD domain.
     */
    @JvmName("jbgtfucknxamxgxh")
    public suspend
    fun primaryDomainController(argument: suspend ActiveDirectoryDomainControllerArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryDomainControllerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryDomainController = mapped
    }

    /**
     * @param value null
     */
    @JvmName("wfcrtkrulnnxffgg")
    public suspend
    fun secondaryDomainControllers(`value`: List<ActiveDirectoryDomainControllerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryDomainControllers = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("wgqndvxlntjejijs")
    public suspend
    fun secondaryDomainControllers(argument: List<suspend ActiveDirectoryDomainControllerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActiveDirectoryDomainControllerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryDomainControllers = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("jyoryhhfrybaxhis")
    public suspend fun secondaryDomainControllers(
        vararg
        argument: suspend ActiveDirectoryDomainControllerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ActiveDirectoryDomainControllerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryDomainControllers = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("ylvmvdnekeobwgyj")
    public suspend
    fun secondaryDomainControllers(argument: suspend ActiveDirectoryDomainControllerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ActiveDirectoryDomainControllerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secondaryDomainControllers = mapped
    }

    /**
     * @param values null
     */
    @JvmName("eynycidykpdwfwty")
    public suspend fun secondaryDomainControllers(
        vararg
        values: ActiveDirectoryDomainControllerArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryDomainControllers = mapped
    }

    internal fun build(): ActiveDirectoryDomainControllersArgs = ActiveDirectoryDomainControllersArgs(
        primaryDomainController = primaryDomainController,
        secondaryDomainControllers = secondaryDomainControllers,
    )
}
