@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Active Directory information that related to the resource.
 * @property keytabInformation Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
 */
public data class ActiveDirectoryInformationArgs(
    public val keytabInformation: Output<KeytabInformationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryInformationArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryInformationArgs.builder()
            .keytabInformation(
                keytabInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ActiveDirectoryInformationArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryInformationArgsBuilder internal constructor() {
    private var keytabInformation: Output<KeytabInformationArgs>? = null

    /**
     * @param value Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
     */
    @JvmName("kykpfxuugasmnvbh")
    public suspend fun keytabInformation(`value`: Output<KeytabInformationArgs>) {
        this.keytabInformation = value
    }

    /**
     * @param value Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
     */
    @JvmName("qykbmpjqmeenrdvt")
    public suspend fun keytabInformation(`value`: KeytabInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keytabInformation = mapped
    }

    /**
     * @param argument Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
     */
    @JvmName("pffydafgmlahlege")
    public suspend fun keytabInformation(argument: suspend KeytabInformationArgsBuilder.() -> Unit) {
        val toBeMapped = KeytabInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keytabInformation = mapped
    }

    internal fun build(): ActiveDirectoryInformationArgs = ActiveDirectoryInformationArgs(
        keytabInformation = keytabInformation,
    )
}
