@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupSpecArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.FailoverGroupPartnerSyncMode
import com.pulumi.azurenative.azurearcdata.kotlin.enums.InstanceFailoverGroupRole
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The specifications of the failover group resource.
 * @property partnerMI The name of the partner SQL managed instance.
 * @property partnerMirroringCert The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
 * @property partnerMirroringURL The mirroring endpoint URL of the partner SQL managed instance.
 * @property partnerSyncMode The partner sync mode of the SQL managed instance.
 * @property role The role of the SQL managed instance in this failover group.
 * @property sharedName The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
 * @property sourceMI The name of the SQL managed instance with this failover group role.
 */
public data class FailoverGroupSpecArgs(
    public val partnerMI: Output<String>? = null,
    public val partnerMirroringCert: Output<String>? = null,
    public val partnerMirroringURL: Output<String>? = null,
    public val partnerSyncMode: Output<Either<String, FailoverGroupPartnerSyncMode>>? = null,
    public val role: Output<Either<String, InstanceFailoverGroupRole>>,
    public val sharedName: Output<String>? = null,
    public val sourceMI: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupSpecArgs =
        com.pulumi.azurenative.azurearcdata.inputs.FailoverGroupSpecArgs.builder()
            .partnerMI(partnerMI?.applyValue({ args0 -> args0 }))
            .partnerMirroringCert(partnerMirroringCert?.applyValue({ args0 -> args0 }))
            .partnerMirroringURL(partnerMirroringURL?.applyValue({ args0 -> args0 }))
            .partnerSyncMode(
                partnerSyncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .role(
                role.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sharedName(sharedName?.applyValue({ args0 -> args0 }))
            .sourceMI(sourceMI?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FailoverGroupSpecArgs].
 */
@PulumiTagMarker
public class FailoverGroupSpecArgsBuilder internal constructor() {
    private var partnerMI: Output<String>? = null

    private var partnerMirroringCert: Output<String>? = null

    private var partnerMirroringURL: Output<String>? = null

    private var partnerSyncMode: Output<Either<String, FailoverGroupPartnerSyncMode>>? = null

    private var role: Output<Either<String, InstanceFailoverGroupRole>>? = null

    private var sharedName: Output<String>? = null

    private var sourceMI: Output<String>? = null

    /**
     * @param value The name of the partner SQL managed instance.
     */
    @JvmName("jukqnbqytwqdbpgi")
    public suspend fun partnerMI(`value`: Output<String>) {
        this.partnerMI = value
    }

    /**
     * @param value The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
     */
    @JvmName("qtoswsdywgetpkoo")
    public suspend fun partnerMirroringCert(`value`: Output<String>) {
        this.partnerMirroringCert = value
    }

    /**
     * @param value The mirroring endpoint URL of the partner SQL managed instance.
     */
    @JvmName("asadaxmxlacldwmx")
    public suspend fun partnerMirroringURL(`value`: Output<String>) {
        this.partnerMirroringURL = value
    }

    /**
     * @param value The partner sync mode of the SQL managed instance.
     */
    @JvmName("sfcfilnflrbrypwk")
    public suspend
    fun partnerSyncMode(`value`: Output<Either<String, FailoverGroupPartnerSyncMode>>) {
        this.partnerSyncMode = value
    }

    /**
     * @param value The role of the SQL managed instance in this failover group.
     */
    @JvmName("gxgoapcjttchqksb")
    public suspend fun role(`value`: Output<Either<String, InstanceFailoverGroupRole>>) {
        this.role = value
    }

    /**
     * @param value The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
     */
    @JvmName("qpyjflkjepjnxhnd")
    public suspend fun sharedName(`value`: Output<String>) {
        this.sharedName = value
    }

    /**
     * @param value The name of the SQL managed instance with this failover group role.
     */
    @JvmName("ypykipryapxlensr")
    public suspend fun sourceMI(`value`: Output<String>) {
        this.sourceMI = value
    }

    /**
     * @param value The name of the partner SQL managed instance.
     */
    @JvmName("cjepbajcfbxhbyui")
    public suspend fun partnerMI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerMI = mapped
    }

    /**
     * @param value The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
     */
    @JvmName("pspleyqmlflmoxpu")
    public suspend fun partnerMirroringCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerMirroringCert = mapped
    }

    /**
     * @param value The mirroring endpoint URL of the partner SQL managed instance.
     */
    @JvmName("kpuwbdmjbnwfysbt")
    public suspend fun partnerMirroringURL(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerMirroringURL = mapped
    }

    /**
     * @param value The partner sync mode of the SQL managed instance.
     */
    @JvmName("lamolavgxihkkcwj")
    public suspend fun partnerSyncMode(`value`: Either<String, FailoverGroupPartnerSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerSyncMode = mapped
    }

    /**
     * @param value The partner sync mode of the SQL managed instance.
     */
    @JvmName("ppjdcbqjutghwcoh")
    public fun partnerSyncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FailoverGroupPartnerSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerSyncMode = mapped
    }

    /**
     * @param value The partner sync mode of the SQL managed instance.
     */
    @JvmName("wgkgdmhpmwoljbmk")
    public fun partnerSyncMode(`value`: FailoverGroupPartnerSyncMode) {
        val toBeMapped = Either.ofRight<String, FailoverGroupPartnerSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerSyncMode = mapped
    }

    /**
     * @param value The role of the SQL managed instance in this failover group.
     */
    @JvmName("lgammbrbgaifxdeq")
    public suspend fun role(`value`: Either<String, InstanceFailoverGroupRole>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The role of the SQL managed instance in this failover group.
     */
    @JvmName("xdtcpvbkgthnmato")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InstanceFailoverGroupRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The role of the SQL managed instance in this failover group.
     */
    @JvmName("yxgcxbghxeeebxnm")
    public fun role(`value`: InstanceFailoverGroupRole) {
        val toBeMapped = Either.ofRight<String, InstanceFailoverGroupRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
     */
    @JvmName("mjqtklvktwfaetqi")
    public suspend fun sharedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedName = mapped
    }

    /**
     * @param value The name of the SQL managed instance with this failover group role.
     */
    @JvmName("qeumkerbvfutofwt")
    public suspend fun sourceMI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceMI = mapped
    }

    internal fun build(): FailoverGroupSpecArgs = FailoverGroupSpecArgs(
        partnerMI = partnerMI,
        partnerMirroringCert = partnerMirroringCert,
        partnerMirroringURL = partnerMirroringURL,
        partnerSyncMode = partnerSyncMode,
        role = role ?: throw PulumiNullFieldException("role"),
        sharedName = sharedName,
        sourceMI = sourceMI,
    )
}
