@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetFailoverGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failoverGroupName The name of the Failover Group
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlManagedInstanceName Name of SQL Managed Instance
 */
public data class GetFailoverGroupPlainArgs(
    public val failoverGroupName: String,
    public val resourceGroupName: String,
    public val sqlManagedInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetFailoverGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetFailoverGroupPlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetFailoverGroupPlainArgs.builder()
            .failoverGroupName(failoverGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlManagedInstanceName(sqlManagedInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFailoverGroupPlainArgs].
 */
@PulumiTagMarker
public class GetFailoverGroupPlainArgsBuilder internal constructor() {
    private var failoverGroupName: String? = null

    private var resourceGroupName: String? = null

    private var sqlManagedInstanceName: String? = null

    /**
     * @param value The name of the Failover Group
     */
    @JvmName("rdprfuqhnlplfvra")
    public suspend fun failoverGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.failoverGroupName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("afsilanswjkpwbyp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("uetqpyvvvddwhvot")
    public suspend fun sqlManagedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlManagedInstanceName = mapped
    }

    internal fun build(): GetFailoverGroupPlainArgs = GetFailoverGroupPlainArgs(
        failoverGroupName = failoverGroupName ?: throw PulumiNullFieldException("failoverGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlManagedInstanceName = sqlManagedInstanceName ?: throw
            PulumiNullFieldException("sqlManagedInstanceName"),
    )
}
