@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstanceTelemetryPlainArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.AggregationType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aggregationType The aggregation type to use for the numerical columns in the dataset.
 * @property databaseNames The list of database names to return telemetry for. If not specified, telemetry for all databases will be aggregated and returned.
 * @property datasetName The name of the telemetry dataset to retrieve.
 * @property endTime The end time for the time range to fetch telemetry for. If not specified, the current time is used.
 * @property interval The time granularity to fetch telemetry for. This is an ISO8601 duration. Examples: PT15M, PT1H, P1D
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 * @property startTime The start time for the time range to fetch telemetry for. If not specified, the current time minus 1 hour is used.
 */
public data class GetSqlServerInstanceTelemetryPlainArgs(
    public val aggregationType: Either<String, AggregationType>? = null,
    public val databaseNames: List<String>? = null,
    public val datasetName: String,
    public val endTime: String? = null,
    public val interval: String? = null,
    public val resourceGroupName: String,
    public val sqlServerInstanceName: String,
    public val startTime: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstanceTelemetryPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstanceTelemetryPlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstanceTelemetryPlainArgs.builder()
            .aggregationType(
                aggregationType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseNames(databaseNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .datasetName(datasetName.let({ args0 -> args0 }))
            .endTime(endTime?.let({ args0 -> args0 }))
            .interval(interval?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerInstanceTelemetryPlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerInstanceTelemetryPlainArgsBuilder internal constructor() {
    private var aggregationType: Either<String, AggregationType>? = null

    private var databaseNames: List<String>? = null

    private var datasetName: String? = null

    private var endTime: String? = null

    private var interval: String? = null

    private var resourceGroupName: String? = null

    private var sqlServerInstanceName: String? = null

    private var startTime: String? = null

    /**
     * @param value The aggregation type to use for the numerical columns in the dataset.
     */
    @JvmName("eeedgufawmhvmbjs")
    public suspend fun aggregationType(`value`: Either<String, AggregationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aggregationType = mapped
    }

    /**
     * @param value The aggregation type to use for the numerical columns in the dataset.
     */
    @JvmName("ilssjdkevamudqly")
    public fun aggregationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AggregationType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aggregationType = mapped
    }

    /**
     * @param value The aggregation type to use for the numerical columns in the dataset.
     */
    @JvmName("xjestwoplgvxrsaw")
    public fun aggregationType(`value`: AggregationType) {
        val toBeMapped = Either.ofRight<String, AggregationType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aggregationType = mapped
    }

    /**
     * @param value The list of database names to return telemetry for. If not specified, telemetry for all databases will be aggregated and returned.
     */
    @JvmName("bcxvyjdyvkvihytk")
    public suspend fun databaseNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.databaseNames = mapped
    }

    /**
     * @param values The list of database names to return telemetry for. If not specified, telemetry for all databases will be aggregated and returned.
     */
    @JvmName("ygnnkpoonwvignwf")
    public suspend fun databaseNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseNames = mapped
    }

    /**
     * @param value The name of the telemetry dataset to retrieve.
     */
    @JvmName("kwurejswetusrgbe")
    public suspend fun datasetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datasetName = mapped
    }

    /**
     * @param value The end time for the time range to fetch telemetry for. If not specified, the current time is used.
     */
    @JvmName("jqccpsblgfpkmfnc")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value The time granularity to fetch telemetry for. This is an ISO8601 duration. Examples: PT15M, PT1H, P1D
     */
    @JvmName("wwjbglmhemrfpksl")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.interval = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("xrqotiwfucuwwnny")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("grertqrjelgfbuok")
    public suspend fun sqlServerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerInstanceName = mapped
    }

    /**
     * @param value The start time for the time range to fetch telemetry for. If not specified, the current time minus 1 hour is used.
     */
    @JvmName("uqjcgvdsrqxqxmfb")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetSqlServerInstanceTelemetryPlainArgs =
        GetSqlServerInstanceTelemetryPlainArgs(
            aggregationType = aggregationType,
            databaseNames = databaseNames,
            datasetName = datasetName ?: throw PulumiNullFieldException("datasetName"),
            endTime = endTime,
            interval = interval,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlServerInstanceName = sqlServerInstanceName ?: throw
                PulumiNullFieldException("sqlServerInstanceName"),
            startTime = startTime,
        )
}
