@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The kubernetes active directory information.
 * @property accountName Account name for AAD
 * @property connector
 * @property encryptionTypes An array of encryption types
 * @property keytabSecret Keytab secret used to authenticate with Active Directory.
 */
public data class K8sActiveDirectoryArgs(
    public val accountName: Output<String>? = null,
    public val connector: Output<K8sActiveDirectoryConnectorArgs>? = null,
    public val encryptionTypes: Output<List<String>>? = null,
    public val keytabSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .connector(connector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionTypes(encryptionTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keytabSecret(keytabSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sActiveDirectoryArgs].
 */
@PulumiTagMarker
public class K8sActiveDirectoryArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var connector: Output<K8sActiveDirectoryConnectorArgs>? = null

    private var encryptionTypes: Output<List<String>>? = null

    private var keytabSecret: Output<String>? = null

    /**
     * @param value Account name for AAD
     */
    @JvmName("bjuqrrtfupjkwofi")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value
     */
    @JvmName("iyachvsvrbaabxle")
    public suspend fun connector(`value`: Output<K8sActiveDirectoryConnectorArgs>) {
        this.connector = value
    }

    /**
     * @param value An array of encryption types
     */
    @JvmName("nebooqqconfrjaeq")
    public suspend fun encryptionTypes(`value`: Output<List<String>>) {
        this.encryptionTypes = value
    }

    @JvmName("mscinhqiouotxanb")
    public suspend fun encryptionTypes(vararg values: Output<String>) {
        this.encryptionTypes = Output.all(values.asList())
    }

    /**
     * @param values An array of encryption types
     */
    @JvmName("ljgypytybujqumsi")
    public suspend fun encryptionTypes(values: List<Output<String>>) {
        this.encryptionTypes = Output.all(values)
    }

    /**
     * @param value Keytab secret used to authenticate with Active Directory.
     */
    @JvmName("jdysiigumsobejhy")
    public suspend fun keytabSecret(`value`: Output<String>) {
        this.keytabSecret = value
    }

    /**
     * @param value Account name for AAD
     */
    @JvmName("pkifsfegkgtscose")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qmoratqkudedcrri")
    public suspend fun connector(`value`: K8sActiveDirectoryConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connector = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cjfckvrilygtkpkr")
    public suspend
    fun connector(argument: suspend K8sActiveDirectoryConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = K8sActiveDirectoryConnectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connector = mapped
    }

    /**
     * @param value An array of encryption types
     */
    @JvmName("bwcfrbawufxbvtsd")
    public suspend fun encryptionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionTypes = mapped
    }

    /**
     * @param values An array of encryption types
     */
    @JvmName("vqsywjmnqalxakgm")
    public suspend fun encryptionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionTypes = mapped
    }

    /**
     * @param value Keytab secret used to authenticate with Active Directory.
     */
    @JvmName("nonhchjhgqgylhpl")
    public suspend fun keytabSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keytabSecret = mapped
    }

    internal fun build(): K8sActiveDirectoryArgs = K8sActiveDirectoryArgs(
        accountName = accountName,
        connector = connector,
        encryptionTypes = encryptionTypes,
        keytabSecret = keytabSecret,
    )
}
