@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the connector
 * @property namespace Name space of the connector
 */
public data class K8sActiveDirectoryConnectorArgs(
    public val name: Output<String>? = null,
    public val namespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryConnectorArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sActiveDirectoryConnectorArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sActiveDirectoryConnectorArgs].
 */
@PulumiTagMarker
public class K8sActiveDirectoryConnectorArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Name of the connector
     */
    @JvmName("roidvvcdjadmpeur")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name space of the connector
     */
    @JvmName("aclawckjsipshfil")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Name of the connector
     */
    @JvmName("gippmaytclyvonhe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name space of the connector
     */
    @JvmName("jhvdoamarhinrebg")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): K8sActiveDirectoryConnectorArgs = K8sActiveDirectoryConnectorArgs(
        name = name,
        namespace = namespace,
    )
}
