@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.PostgresInstanceSkuTier
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property dev Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU.  It is typically a letter+number code
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier This field is required to be implemented by the Resource Provider if the service has more than one tier.
 */
public data class PostgresInstanceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val dev: Output<Boolean>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<PostgresInstanceSkuTier>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs =
        com.pulumi.azurenative.azurearcdata.inputs.PostgresInstanceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .dev(dev?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PostgresInstanceSkuArgs].
 */
@PulumiTagMarker
public class PostgresInstanceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var dev: Output<Boolean>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<PostgresInstanceSkuTier>? = null

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("ixcgalgqstmkphvd")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
     */
    @JvmName("sbopglyekuxrhkip")
    public suspend fun dev(`value`: Output<Boolean>) {
        this.dev = value
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("mqsfhikuvmnukdxb")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU.  It is typically a letter+number code
     */
    @JvmName("ycftslqkfyyvxfha")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("mvmdnpeyufcdgbor")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier.
     */
    @JvmName("xpwtxicjttnovblx")
    public suspend fun tier(`value`: Output<PostgresInstanceSkuTier>) {
        this.tier = value
    }

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("tgcvqaksmvdpdjde")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
     */
    @JvmName("mtkwaoqgtgmoxfxq")
    public suspend fun dev(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dev = mapped
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("yvmcafxaewjxvdcj")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU.  It is typically a letter+number code
     */
    @JvmName("xtgtcbdrlfpjprmw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("twhpqtfsavuibklv")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier.
     */
    @JvmName("mdvnwfilexmfqrdb")
    public suspend fun tier(`value`: PostgresInstanceSkuTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): PostgresInstanceSkuArgs = PostgresInstanceSkuArgs(
        capacity = capacity,
        dev = dev,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
