@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstancePropertiesArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.ArcSqlManagedInstanceLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of sqlManagedInstance.
 * @property activeDirectoryInformation Active Directory information related to this SQL Managed Instance.
 * @property admin The instance admin user
 * @property basicLoginInformation Username and password for basic authentication.
 * @property clusterId If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
 * @property dataControllerId null
 * @property endTime The instance end time
 * @property extensionId If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 * @property licenseType The license type to apply for this managed instance.
 * @property startTime The instance start time
 */
public data class SqlManagedInstancePropertiesArgs(
    public val activeDirectoryInformation: Output<ActiveDirectoryInformationArgs>? = null,
    public val admin: Output<String>? = null,
    public val basicLoginInformation: Output<BasicLoginInformationArgs>? = null,
    public val clusterId: Output<String>? = null,
    public val dataControllerId: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val extensionId: Output<String>? = null,
    public val k8sRaw: Output<SqlManagedInstanceK8sRawArgs>? = null,
    public val lastUploadedDate: Output<String>? = null,
    public val licenseType: Output<Either<String, ArcSqlManagedInstanceLicenseType>>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstancePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstancePropertiesArgs.builder()
            .activeDirectoryInformation(
                activeDirectoryInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .admin(admin?.applyValue({ args0 -> args0 }))
            .basicLoginInformation(
                basicLoginInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .dataControllerId(dataControllerId?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .extensionId(extensionId?.applyValue({ args0 -> args0 }))
            .k8sRaw(k8sRaw?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lastUploadedDate(lastUploadedDate?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlManagedInstancePropertiesArgs].
 */
@PulumiTagMarker
public class SqlManagedInstancePropertiesArgsBuilder internal constructor() {
    private var activeDirectoryInformation: Output<ActiveDirectoryInformationArgs>? = null

    private var admin: Output<String>? = null

    private var basicLoginInformation: Output<BasicLoginInformationArgs>? = null

    private var clusterId: Output<String>? = null

    private var dataControllerId: Output<String>? = null

    private var endTime: Output<String>? = null

    private var extensionId: Output<String>? = null

    private var k8sRaw: Output<SqlManagedInstanceK8sRawArgs>? = null

    private var lastUploadedDate: Output<String>? = null

    private var licenseType: Output<Either<String, ArcSqlManagedInstanceLicenseType>>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Active Directory information related to this SQL Managed Instance.
     */
    @JvmName("rbgiotamybsjxlcm")
    public suspend fun activeDirectoryInformation(`value`: Output<ActiveDirectoryInformationArgs>) {
        this.activeDirectoryInformation = value
    }

    /**
     * @param value The instance admin user
     */
    @JvmName("cuaptlpxrhewvlsa")
    public suspend fun admin(`value`: Output<String>) {
        this.admin = value
    }

    /**
     * @param value Username and password for basic authentication.
     */
    @JvmName("jdcoptncwjtjnimu")
    public suspend fun basicLoginInformation(`value`: Output<BasicLoginInformationArgs>) {
        this.basicLoginInformation = value
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
     */
    @JvmName("rrlenxgiyecfuxbq")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value null
     */
    @JvmName("ncfjfpyjtmffluqj")
    public suspend fun dataControllerId(`value`: Output<String>) {
        this.dataControllerId = value
    }

    /**
     * @param value The instance end time
     */
    @JvmName("qgkdqqumxnfiyntd")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
     */
    @JvmName("uibxefkcdnkgyjep")
    public suspend fun extensionId(`value`: Output<String>) {
        this.extensionId = value
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("fkgfmqmyxilpowwl")
    public suspend fun k8sRaw(`value`: Output<SqlManagedInstanceK8sRawArgs>) {
        this.k8sRaw = value
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("xcarexbrdyyrlhyy")
    public suspend fun lastUploadedDate(`value`: Output<String>) {
        this.lastUploadedDate = value
    }

    /**
     * @param value The license type to apply for this managed instance.
     */
    @JvmName("iflixlsbdnlrbaom")
    public suspend
    fun licenseType(`value`: Output<Either<String, ArcSqlManagedInstanceLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The instance start time
     */
    @JvmName("obtfxaphblhahmfm")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Active Directory information related to this SQL Managed Instance.
     */
    @JvmName("gkrxlkhdnwpoamwi")
    public suspend fun activeDirectoryInformation(`value`: ActiveDirectoryInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryInformation = mapped
    }

    /**
     * @param argument Active Directory information related to this SQL Managed Instance.
     */
    @JvmName("qukcvxmffsockicv")
    public suspend
    fun activeDirectoryInformation(argument: suspend ActiveDirectoryInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activeDirectoryInformation = mapped
    }

    /**
     * @param value The instance admin user
     */
    @JvmName("bnrfkhnlauuopjsb")
    public suspend fun admin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admin = mapped
    }

    /**
     * @param value Username and password for basic authentication.
     */
    @JvmName("gcpqabyhmklhnthm")
    public suspend fun basicLoginInformation(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicLoginInformation = mapped
    }

    /**
     * @param argument Username and password for basic authentication.
     */
    @JvmName("wjactnvwwqyjtaqt")
    public suspend
    fun basicLoginInformation(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.basicLoginInformation = mapped
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
     */
    @JvmName("showwikhonfhenmj")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value null
     */
    @JvmName("ofcrneijjlpeopdx")
    public suspend fun dataControllerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataControllerId = mapped
    }

    /**
     * @param value The instance end time
     */
    @JvmName("itwxjrmhxibbljyv")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
     */
    @JvmName("qygudndsvtmmkpbn")
    public suspend fun extensionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionId = mapped
    }

    /**
     * @param value The raw kubernetes information
     */
    @JvmName("kdnskefxshcvtyls")
    public suspend fun k8sRaw(`value`: SqlManagedInstanceK8sRawArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.k8sRaw = mapped
    }

    /**
     * @param argument The raw kubernetes information
     */
    @JvmName("akfkqhhimhofuhpj")
    public suspend fun k8sRaw(argument: suspend SqlManagedInstanceK8sRawArgsBuilder.() -> Unit) {
        val toBeMapped = SqlManagedInstanceK8sRawArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.k8sRaw = mapped
    }

    /**
     * @param value Last uploaded date from Kubernetes cluster. Defaults to current date time
     */
    @JvmName("yyhgllkaqabkrsre")
    public suspend fun lastUploadedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUploadedDate = mapped
    }

    /**
     * @param value The license type to apply for this managed instance.
     */
    @JvmName("fdneqrutimdkfwua")
    public suspend fun licenseType(`value`: Either<String, ArcSqlManagedInstanceLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to apply for this managed instance.
     */
    @JvmName("ebnrnkhjhpovuplm")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArcSqlManagedInstanceLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to apply for this managed instance.
     */
    @JvmName("lylvcqqwvfadaqqv")
    public fun licenseType(`value`: ArcSqlManagedInstanceLicenseType) {
        val toBeMapped = Either.ofRight<String, ArcSqlManagedInstanceLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The instance start time
     */
    @JvmName("wvbabjwogacfjbxy")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): SqlManagedInstancePropertiesArgs = SqlManagedInstancePropertiesArgs(
        activeDirectoryInformation = activeDirectoryInformation,
        admin = admin,
        basicLoginInformation = basicLoginInformation,
        clusterId = clusterId,
        dataControllerId = dataControllerId,
        endTime = endTime,
        extensionId = extensionId,
        k8sRaw = k8sRaw,
        lastUploadedDate = lastUploadedDate,
        licenseType = licenseType,
        startTime = startTime,
    )
}
