@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of Arc Sql Server availability group resource
 * @property databases A list of Availability Group Database Replicas.
 * @property info Availability Group Info
 * @property replicas A list of Availability Group Replicas.
 */
public data class SqlServerAvailabilityGroupResourcePropertiesArgs(
    public val databases: Output<SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs>? = null,
    public val info: Output<AvailabilityGroupInfoArgs>? = null,
    public val replicas: Output<SqlServerAvailabilityGroupResourcePropertiesReplicasArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesArgs.builder()
            .databases(databases?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .info(info?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicas(replicas?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SqlServerAvailabilityGroupResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SqlServerAvailabilityGroupResourcePropertiesArgsBuilder internal constructor() {
    private var databases: Output<SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs>? = null

    private var info: Output<AvailabilityGroupInfoArgs>? = null

    private var replicas: Output<SqlServerAvailabilityGroupResourcePropertiesReplicasArgs>? = null

    /**
     * @param value A list of Availability Group Database Replicas.
     */
    @JvmName("iccclrxsmcrvxqic")
    public suspend
    fun databases(`value`: Output<SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs>) {
        this.databases = value
    }

    /**
     * @param value Availability Group Info
     */
    @JvmName("eiqiirbtafclybre")
    public suspend fun info(`value`: Output<AvailabilityGroupInfoArgs>) {
        this.info = value
    }

    /**
     * @param value A list of Availability Group Replicas.
     */
    @JvmName("sgfrknultbggqyod")
    public suspend
    fun replicas(`value`: Output<SqlServerAvailabilityGroupResourcePropertiesReplicasArgs>) {
        this.replicas = value
    }

    /**
     * @param value A list of Availability Group Database Replicas.
     */
    @JvmName("ehkwwadtdckckntc")
    public suspend
    fun databases(`value`: SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param argument A list of Availability Group Database Replicas.
     */
    @JvmName("wuqcubbhclfoaswc")
    public suspend
    fun databases(argument: suspend SqlServerAvailabilityGroupResourcePropertiesDatabasesArgsBuilder.() -> Unit) {
        val toBeMapped =
            SqlServerAvailabilityGroupResourcePropertiesDatabasesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param value Availability Group Info
     */
    @JvmName("auslcsktjwutltge")
    public suspend fun info(`value`: AvailabilityGroupInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.info = mapped
    }

    /**
     * @param argument Availability Group Info
     */
    @JvmName("clwiorxvabecqanj")
    public suspend fun info(argument: suspend AvailabilityGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AvailabilityGroupInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.info = mapped
    }

    /**
     * @param value A list of Availability Group Replicas.
     */
    @JvmName("aqaptgrndovjktsl")
    public suspend fun replicas(`value`: SqlServerAvailabilityGroupResourcePropertiesReplicasArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param argument A list of Availability Group Replicas.
     */
    @JvmName("vbplqxsetihphjuk")
    public suspend
    fun replicas(argument: suspend SqlServerAvailabilityGroupResourcePropertiesReplicasArgsBuilder.() -> Unit) {
        val toBeMapped = SqlServerAvailabilityGroupResourcePropertiesReplicasArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    internal fun build(): SqlServerAvailabilityGroupResourcePropertiesArgs =
        SqlServerAvailabilityGroupResourcePropertiesArgs(
            databases = databases,
            info = info,
            replicas = replicas,
        )
}
