@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of Availability Group Database Replicas.
 * @property value Array of Availability Group Database Replicas.
 */
public data class SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs(
    public val `value`: Output<List<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs.builder()
            .`value`(
                `value`?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs].
 */
@PulumiTagMarker
public class SqlServerAvailabilityGroupResourcePropertiesDatabasesArgsBuilder internal constructor() {
    private var `value`: Output<List<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>>? =
        null

    /**
     * @param value Array of Availability Group Database Replicas.
     */
    @JvmName("qxmjdvjqttedasxg")
    public suspend
    fun `value`(`value`: Output<List<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>>) {
        this.`value` = value
    }

    @JvmName("ugyxbxewtrqrkotx")
    public suspend fun `value`(
        vararg
        values: Output<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>,
    ) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values Array of Availability Group Database Replicas.
     */
    @JvmName("wshhbcpuvjoqgeiu")
    public suspend
    fun `value`(values: List<Output<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value Array of Availability Group Database Replicas.
     */
    @JvmName("krvfigeaskfxkwrw")
    public suspend
    fun `value`(`value`: List<SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Database Replicas.
     */
    @JvmName("kgxqicsajgxwrcju")
    public suspend
    fun `value`(argument: List<suspend SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Database Replicas.
     */
    @JvmName("olvscqclexnqiuhp")
    public suspend fun `value`(
        vararg
        argument: suspend SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Database Replicas.
     */
    @JvmName("ctmdulswstyhxgyu")
    public suspend
    fun `value`(argument: suspend SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param values Array of Availability Group Database Replicas.
     */
    @JvmName("rdnktwgnweidvypq")
    public suspend fun `value`(
        vararg
        values: SqlAvailabilityGroupDatabaseReplicaResourcePropertiesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs =
        SqlServerAvailabilityGroupResourcePropertiesDatabasesArgs(
            `value` = `value`,
        )
}
