@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of Availability Group Replicas.
 * @property value Array of Availability Group Replicas.
 */
public data class SqlServerAvailabilityGroupResourcePropertiesReplicasArgs(
    public val `value`: Output<List<SqlAvailabilityGroupReplicaResourcePropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerAvailabilityGroupResourcePropertiesReplicasArgs.builder()
            .`value`(
                `value`?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlServerAvailabilityGroupResourcePropertiesReplicasArgs].
 */
@PulumiTagMarker
public class SqlServerAvailabilityGroupResourcePropertiesReplicasArgsBuilder internal constructor() {
    private var `value`: Output<List<SqlAvailabilityGroupReplicaResourcePropertiesArgs>>? = null

    /**
     * @param value Array of Availability Group Replicas.
     */
    @JvmName("gguhqbbmskaywbxx")
    public suspend
    fun `value`(`value`: Output<List<SqlAvailabilityGroupReplicaResourcePropertiesArgs>>) {
        this.`value` = value
    }

    @JvmName("gxenxwfxjxidgrot")
    public suspend fun `value`(
        vararg
        values: Output<SqlAvailabilityGroupReplicaResourcePropertiesArgs>,
    ) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values Array of Availability Group Replicas.
     */
    @JvmName("pgjmrbkoeaabgjfs")
    public suspend
    fun `value`(values: List<Output<SqlAvailabilityGroupReplicaResourcePropertiesArgs>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value Array of Availability Group Replicas.
     */
    @JvmName("mtuokhsquvywdxdh")
    public suspend fun `value`(`value`: List<SqlAvailabilityGroupReplicaResourcePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Replicas.
     */
    @JvmName("mwhtxjemjftdifst")
    public suspend
    fun `value`(argument: List<suspend SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Replicas.
     */
    @JvmName("dhdsnquappkehoqx")
    public suspend fun `value`(
        vararg
        argument: suspend SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument Array of Availability Group Replicas.
     */
    @JvmName("lynuptkfsejxoran")
    public suspend
    fun `value`(argument: suspend SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param values Array of Availability Group Replicas.
     */
    @JvmName("rmlnpnlbmatgbnqf")
    public suspend fun `value`(vararg values: SqlAvailabilityGroupReplicaResourcePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SqlServerAvailabilityGroupResourcePropertiesReplicasArgs =
        SqlServerAvailabilityGroupResourcePropertiesReplicasArgs(
            `value` = `value`,
        )
}
