@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of features that are enabled for the database
 * @property isAutoCloseOn
 * @property isAutoCreateStatsOn
 * @property isAutoShrinkOn
 * @property isAutoUpdateStatsOn
 * @property isEncrypted
 * @property isMemoryOptimizationEnabled
 * @property isRemoteDataArchiveEnabled
 * @property isTrustworthyOn
 */
public data class SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs(
    public val isAutoCloseOn: Output<Boolean>? = null,
    public val isAutoCreateStatsOn: Output<Boolean>? = null,
    public val isAutoShrinkOn: Output<Boolean>? = null,
    public val isAutoUpdateStatsOn: Output<Boolean>? = null,
    public val isEncrypted: Output<Boolean>? = null,
    public val isMemoryOptimizationEnabled: Output<Boolean>? = null,
    public val isRemoteDataArchiveEnabled: Output<Boolean>? = null,
    public val isTrustworthyOn: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs.builder()
            .isAutoCloseOn(isAutoCloseOn?.applyValue({ args0 -> args0 }))
            .isAutoCreateStatsOn(isAutoCreateStatsOn?.applyValue({ args0 -> args0 }))
            .isAutoShrinkOn(isAutoShrinkOn?.applyValue({ args0 -> args0 }))
            .isAutoUpdateStatsOn(isAutoUpdateStatsOn?.applyValue({ args0 -> args0 }))
            .isEncrypted(isEncrypted?.applyValue({ args0 -> args0 }))
            .isMemoryOptimizationEnabled(isMemoryOptimizationEnabled?.applyValue({ args0 -> args0 }))
            .isRemoteDataArchiveEnabled(isRemoteDataArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isTrustworthyOn(isTrustworthyOn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs].
 */
@PulumiTagMarker
public class SqlServerDatabaseResourcePropertiesDatabaseOptionsArgsBuilder internal constructor() {
    private var isAutoCloseOn: Output<Boolean>? = null

    private var isAutoCreateStatsOn: Output<Boolean>? = null

    private var isAutoShrinkOn: Output<Boolean>? = null

    private var isAutoUpdateStatsOn: Output<Boolean>? = null

    private var isEncrypted: Output<Boolean>? = null

    private var isMemoryOptimizationEnabled: Output<Boolean>? = null

    private var isRemoteDataArchiveEnabled: Output<Boolean>? = null

    private var isTrustworthyOn: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("fetiqxyhgiqpkovo")
    public suspend fun isAutoCloseOn(`value`: Output<Boolean>) {
        this.isAutoCloseOn = value
    }

    /**
     * @param value
     */
    @JvmName("ihkgxueolqfgmhwx")
    public suspend fun isAutoCreateStatsOn(`value`: Output<Boolean>) {
        this.isAutoCreateStatsOn = value
    }

    /**
     * @param value
     */
    @JvmName("ualrapjjfnvqrivx")
    public suspend fun isAutoShrinkOn(`value`: Output<Boolean>) {
        this.isAutoShrinkOn = value
    }

    /**
     * @param value
     */
    @JvmName("hwkqcehmvptskpqa")
    public suspend fun isAutoUpdateStatsOn(`value`: Output<Boolean>) {
        this.isAutoUpdateStatsOn = value
    }

    /**
     * @param value
     */
    @JvmName("trkjebgtcurojdnc")
    public suspend fun isEncrypted(`value`: Output<Boolean>) {
        this.isEncrypted = value
    }

    /**
     * @param value
     */
    @JvmName("wcnfbjtyrxjqwuhu")
    public suspend fun isMemoryOptimizationEnabled(`value`: Output<Boolean>) {
        this.isMemoryOptimizationEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("gjhepessaoxhynea")
    public suspend fun isRemoteDataArchiveEnabled(`value`: Output<Boolean>) {
        this.isRemoteDataArchiveEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("tggjeownrbmswxcu")
    public suspend fun isTrustworthyOn(`value`: Output<Boolean>) {
        this.isTrustworthyOn = value
    }

    /**
     * @param value
     */
    @JvmName("pkqqsfjojgvudgny")
    public suspend fun isAutoCloseOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoCloseOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("yluryrfoadslquhr")
    public suspend fun isAutoCreateStatsOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoCreateStatsOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("iywjnqbhotvwfced")
    public suspend fun isAutoShrinkOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoShrinkOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("jqfmcsbhoglrkfqi")
    public suspend fun isAutoUpdateStatsOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoUpdateStatsOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("vfhgqydxsbcmxgsc")
    public suspend fun isEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEncrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("nkwaustmrurelgdi")
    public suspend fun isMemoryOptimizationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMemoryOptimizationEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("wxbrkdntpsliqnsv")
    public suspend fun isRemoteDataArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRemoteDataArchiveEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvmufedmdkgrhqex")
    public suspend fun isTrustworthyOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTrustworthyOn = mapped
    }

    internal fun build(): SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs =
        SqlServerDatabaseResourcePropertiesDatabaseOptionsArgs(
            isAutoCloseOn = isAutoCloseOn,
            isAutoCreateStatsOn = isAutoCreateStatsOn,
            isAutoShrinkOn = isAutoShrinkOn,
            isAutoUpdateStatsOn = isAutoUpdateStatsOn,
            isEncrypted = isEncrypted,
            isMemoryOptimizationEnabled = isMemoryOptimizationEnabled,
            isRemoteDataArchiveEnabled = isRemoteDataArchiveEnabled,
            isTrustworthyOn = isTrustworthyOn,
        )
}
