@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Active Directory domain details
 * @property domainControllers null
 * @property netbiosDomainName NETBIOS name of the Active Directory domain.
 * @property ouDistinguishedName The distinguished name of the Active Directory Organizational Unit.
 * @property realm Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
 * @property serviceAccountProvisioning The service account provisioning mode for this Active Directory connector.
 */
public data class ActiveDirectoryConnectorDomainDetailsResponse(
    public val domainControllers: ActiveDirectoryDomainControllersResponse? = null,
    public val netbiosDomainName: String? = null,
    public val ouDistinguishedName: String? = null,
    public val realm: String,
    public val serviceAccountProvisioning: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.ActiveDirectoryConnectorDomainDetailsResponse):
            ActiveDirectoryConnectorDomainDetailsResponse =
            ActiveDirectoryConnectorDomainDetailsResponse(
                domainControllers = javaType.domainControllers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryDomainControllersResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                netbiosDomainName = javaType.netbiosDomainName().map({ args0 -> args0 }).orElse(null),
                ouDistinguishedName = javaType.ouDistinguishedName().map({ args0 -> args0 }).orElse(null),
                realm = javaType.realm(),
                serviceAccountProvisioning = javaType.serviceAccountProvisioning().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
