@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The specifications of the availability group replica configuration
 * @property availabilityModeDescription The Availability Synchronization mode of the availability group replica.
 * @property backupPriority Represents the user-specified priority for performing backups on this replica relative to the other replicas in the same availability group.
 * @property endpointUrl Mirroring endpoint URL of availability group replica
 * @property failoverModeDescription The failover mode of the availability group replica.
 * @property primaryRoleAllowConnectionsDescription Whether the availability allows all connections or only read-write connections.
 * @property readOnlyRoutingUrl Connectivity endpoint (URL) of the read only availability replica.
 * @property readWriteRoutingUrl Connectivity endpoint (URL) of the read write availability replica.
 * @property replicaCreateDate Date that the replica was created.
 * @property replicaModifyDate Date that the replica was modified.
 * @property secondaryRoleAllowConnectionsDescription Whether an availability replica that is performing the secondary role (that is, a secondary replica) can accept connections from clients.
 * @property seedingModeDescription Describes seeding mode.
 * @property sessionTimeout The time-out period of availability group session replica, in seconds.
 */
public data class AvailabilityGroupConfigureResponse(
    public val availabilityModeDescription: String,
    public val backupPriority: Int? = null,
    public val endpointUrl: String? = null,
    public val failoverModeDescription: String,
    public val primaryRoleAllowConnectionsDescription: String,
    public val readOnlyRoutingUrl: String? = null,
    public val readWriteRoutingUrl: String? = null,
    public val replicaCreateDate: String,
    public val replicaModifyDate: String,
    public val secondaryRoleAllowConnectionsDescription: String,
    public val seedingModeDescription: String,
    public val sessionTimeout: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.AvailabilityGroupConfigureResponse):
            AvailabilityGroupConfigureResponse = AvailabilityGroupConfigureResponse(
            availabilityModeDescription = javaType.availabilityModeDescription(),
            backupPriority = javaType.backupPriority().map({ args0 -> args0 }).orElse(null),
            endpointUrl = javaType.endpointUrl().map({ args0 -> args0 }).orElse(null),
            failoverModeDescription = javaType.failoverModeDescription(),
            primaryRoleAllowConnectionsDescription = javaType.primaryRoleAllowConnectionsDescription(),
            readOnlyRoutingUrl = javaType.readOnlyRoutingUrl().map({ args0 -> args0 }).orElse(null),
            readWriteRoutingUrl = javaType.readWriteRoutingUrl().map({ args0 -> args0 }).orElse(null),
            replicaCreateDate = javaType.replicaCreateDate(),
            replicaModifyDate = javaType.replicaModifyDate(),
            secondaryRoleAllowConnectionsDescription = javaType.secondaryRoleAllowConnectionsDescription(),
            seedingModeDescription = javaType.seedingModeDescription(),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
