@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The specifications of the availability group state
 * @property automatedBackupPreferenceDescription Preferred location for performing backups on the availability databases in this availability group.
 * @property basicFeatures Specifies whether this is a basic availability group.
 * @property clusterTypeDescription SQL Server availability group cluster type description
 * @property dbFailover Specifies whether the availability group supports failover for database health conditions.
 * @property dtcSupport Specifies whether DTC support has been enabled for this availability group.
 * @property failureConditionLevel User-defined failure condition level under which an automatic failover must be triggered.
 * @property healthCheckTimeout Wait time (in milliseconds) for the sp_server_diagnostics system stored procedure to return server-health information, before the server instance is assumed to be slow or not responding.
 * @property isContained SQL Server availability group contained system databases.
 * @property isDistributed Specifies whether this is a distributed availability group.
 * @property primaryRecoveryHealthDescription Indicates the recovery health of the primary replica.
 * @property primaryReplica Name of the server instance that is hosting the current primary replica.
 * @property replicationPartnerType
 * @property requiredSynchronizedSecondariesToCommit The number of secondary replicas that must be in a synchronized state for a commit to complete.
 * @property secondaryRecoveryHealthDescription Indicates the recovery health of a secondary replica.
 * @property synchronizationHealthDescription Reflects a roll-up of the synchronization health of all availability replicas in the availability group.
 * @property version SQL Server availability group current version.
 */
public data class AvailabilityGroupInfoResponse(
    public val automatedBackupPreferenceDescription: String,
    public val basicFeatures: Boolean? = null,
    public val clusterTypeDescription: String,
    public val dbFailover: Boolean? = null,
    public val dtcSupport: Boolean? = null,
    public val failureConditionLevel: Int? = null,
    public val healthCheckTimeout: Int? = null,
    public val isContained: Boolean? = null,
    public val isDistributed: Boolean? = null,
    public val primaryRecoveryHealthDescription: String,
    public val primaryReplica: String,
    public val replicationPartnerType: String,
    public val requiredSynchronizedSecondariesToCommit: Int? = null,
    public val secondaryRecoveryHealthDescription: String,
    public val synchronizationHealthDescription: String,
    public val version: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.AvailabilityGroupInfoResponse):
            AvailabilityGroupInfoResponse = AvailabilityGroupInfoResponse(
            automatedBackupPreferenceDescription = javaType.automatedBackupPreferenceDescription(),
            basicFeatures = javaType.basicFeatures().map({ args0 -> args0 }).orElse(null),
            clusterTypeDescription = javaType.clusterTypeDescription(),
            dbFailover = javaType.dbFailover().map({ args0 -> args0 }).orElse(null),
            dtcSupport = javaType.dtcSupport().map({ args0 -> args0 }).orElse(null),
            failureConditionLevel = javaType.failureConditionLevel().map({ args0 -> args0 }).orElse(null),
            healthCheckTimeout = javaType.healthCheckTimeout().map({ args0 -> args0 }).orElse(null),
            isContained = javaType.isContained().map({ args0 -> args0 }).orElse(null),
            isDistributed = javaType.isDistributed().map({ args0 -> args0 }).orElse(null),
            primaryRecoveryHealthDescription = javaType.primaryRecoveryHealthDescription(),
            primaryReplica = javaType.primaryReplica(),
            replicationPartnerType = javaType.replicationPartnerType(),
            requiredSynchronizedSecondariesToCommit = javaType.requiredSynchronizedSecondariesToCommit().map({ args0 ->
                args0
            }).orElse(null),
            secondaryRecoveryHealthDescription = javaType.secondaryRecoveryHealthDescription(),
            synchronizationHealthDescription = javaType.synchronizationHealthDescription(),
            version = javaType.version(),
        )
    }
}
