@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The specifications of the availability group state
 * @property availabilityGroupReplicaRole Current Always On availability groups role of the availability group replica.
 * @property connectedStateDescription Whether a secondary replica is currently connected to the primary replica.
 * @property lastConnectErrorDescription Text description of the last connection error of the availability group replica.
 * @property lastConnectErrorTimestamp Date and time timestamp indicating when the last connect error occurred.
 * @property operationalStateDescription Current operational state of the availability group replica
 * @property recoveryHealthDescription Recovery health of the availability group replica.
 * @property synchronizationHealthDescription Reflects a rollup of the database synchronization state (synchronization_state) of all joined availability databases (also known as replicas) and the availability mode of the replica (synchronous-commit or asynchronous-commit mode). The rollup will reflect the least healthy accumulated state the databases on the replica.
 */
public data class AvailabilityGroupStateResponse(
    public val availabilityGroupReplicaRole: String,
    public val connectedStateDescription: String,
    public val lastConnectErrorDescription: String,
    public val lastConnectErrorTimestamp: String,
    public val operationalStateDescription: String,
    public val recoveryHealthDescription: String,
    public val synchronizationHealthDescription: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.AvailabilityGroupStateResponse):
            AvailabilityGroupStateResponse = AvailabilityGroupStateResponse(
            availabilityGroupReplicaRole = javaType.availabilityGroupReplicaRole(),
            connectedStateDescription = javaType.connectedStateDescription(),
            lastConnectErrorDescription = javaType.lastConnectErrorDescription(),
            lastConnectErrorTimestamp = javaType.lastConnectErrorTimestamp(),
            operationalStateDescription = javaType.operationalStateDescription(),
            recoveryHealthDescription = javaType.recoveryHealthDescription(),
            synchronizationHealthDescription = javaType.synchronizationHealthDescription(),
        )
    }
}
