@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A section of the telemetry response for the SQL Server instance.
 * @property columns The columns of the result telemetry table for the SQL Server instance.
 * @property nextLink The link to the next section of rows of the telemetry response for the SQL Server instance. Null if no more sections are available.
 * @property rows A list of rows from the result telemetry table for the SQL Server instance.
 */
public data class GetSqlServerInstanceTelemetryResult(
    public val columns: List<SqlServerInstanceTelemetryColumnResponse>,
    public val nextLink: String,
    public val rows: List<List<String>>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.GetSqlServerInstanceTelemetryResult):
            GetSqlServerInstanceTelemetryResult = GetSqlServerInstanceTelemetryResult(
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerInstanceTelemetryColumnResponse.Companion.toKotlin(args0)
                })
            }),
            nextLink = javaType.nextLink(),
            rows = javaType.rows().map({ args0 -> args0.map({ args0 -> args0 }) }),
        )
    }
}
