@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The kubernetes active directory information.
 * @property accountName Account name for AAD
 * @property connector
 * @property encryptionTypes An array of encryption types
 * @property keytabSecret Keytab secret used to authenticate with Active Directory.
 */
public data class K8sActiveDirectoryResponse(
    public val accountName: String? = null,
    public val connector: K8sActiveDirectoryResponseConnector? = null,
    public val encryptionTypes: List<String>? = null,
    public val keytabSecret: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8sActiveDirectoryResponse):
            K8sActiveDirectoryResponse = K8sActiveDirectoryResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            connector = javaType.connector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sActiveDirectoryResponseConnector.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionTypes = javaType.encryptionTypes().map({ args0 -> args0 }),
            keytabSecret = javaType.keytabSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
