@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of Arc Sql Server availability group resource
 * @property availabilityGroupId ID GUID of the availability group.
 * @property collectionTimestamp Timestamp for when the data was collected from the client machine.
 * @property databases A list of Availability Group Database Replicas.
 * @property info Availability Group Info
 * @property instanceName the SQL Server Instance name.
 * @property provisioningState The provisioning state of the Arc-enabled SQL Server availability group resource.
 * @property replicas A list of Availability Group Replicas.
 * @property serverName the SQL server name.
 */
public data class SqlServerAvailabilityGroupResourcePropertiesResponse(
    public val availabilityGroupId: String,
    public val collectionTimestamp: String,
    public val databases: SqlServerAvailabilityGroupResourcePropertiesResponseDatabases? = null,
    public val info: AvailabilityGroupInfoResponse? = null,
    public val instanceName: String,
    public val provisioningState: String,
    public val replicas: SqlServerAvailabilityGroupResourcePropertiesResponseReplicas? = null,
    public val serverName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlServerAvailabilityGroupResourcePropertiesResponse):
            SqlServerAvailabilityGroupResourcePropertiesResponse =
            SqlServerAvailabilityGroupResourcePropertiesResponse(
                availabilityGroupId = javaType.availabilityGroupId(),
                collectionTimestamp = javaType.collectionTimestamp(),
                databases = javaType.databases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerAvailabilityGroupResourcePropertiesResponseDatabases.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                info = javaType.info().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.AvailabilityGroupInfoResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                instanceName = javaType.instanceName(),
                provisioningState = javaType.provisioningState(),
                replicas = javaType.replicas().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerAvailabilityGroupResourcePropertiesResponseReplicas.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serverName = javaType.serverName(),
            )
    }
}
