@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * List of features that are enabled for the database
 * @property isAutoCloseOn
 * @property isAutoCreateStatsOn
 * @property isAutoShrinkOn
 * @property isAutoUpdateStatsOn
 * @property isEncrypted
 * @property isMemoryOptimizationEnabled
 * @property isRemoteDataArchiveEnabled
 * @property isTrustworthyOn
 */
public data class SqlServerDatabaseResourcePropertiesResponseDatabaseOptions(
    public val isAutoCloseOn: Boolean? = null,
    public val isAutoCreateStatsOn: Boolean? = null,
    public val isAutoShrinkOn: Boolean? = null,
    public val isAutoUpdateStatsOn: Boolean? = null,
    public val isEncrypted: Boolean? = null,
    public val isMemoryOptimizationEnabled: Boolean? = null,
    public val isRemoteDataArchiveEnabled: Boolean? = null,
    public val isTrustworthyOn: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlServerDatabaseResourcePropertiesResponseDatabaseOptions):
            SqlServerDatabaseResourcePropertiesResponseDatabaseOptions =
            SqlServerDatabaseResourcePropertiesResponseDatabaseOptions(
                isAutoCloseOn = javaType.isAutoCloseOn().map({ args0 -> args0 }).orElse(null),
                isAutoCreateStatsOn = javaType.isAutoCreateStatsOn().map({ args0 -> args0 }).orElse(null),
                isAutoShrinkOn = javaType.isAutoShrinkOn().map({ args0 -> args0 }).orElse(null),
                isAutoUpdateStatsOn = javaType.isAutoUpdateStatsOn().map({ args0 -> args0 }).orElse(null),
                isEncrypted = javaType.isEncrypted().map({ args0 -> args0 }).orElse(null),
                isMemoryOptimizationEnabled = javaType.isMemoryOptimizationEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                isRemoteDataArchiveEnabled = javaType.isRemoteDataArchiveEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                isTrustworthyOn = javaType.isTrustworthyOn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
