@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of SqlServerInstance.
 * @property azureDefenderStatus Status of Azure Defender.
 * @property azureDefenderStatusLastUpdated Timestamp of last Azure Defender status update.
 * @property collation SQL Server collation.
 * @property containerResourceId ARM Resource id of the container resource (Azure Arc for Servers).
 * @property cores The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
 * @property createTime The time when the resource was created.
 * @property currentVersion SQL Server current version.
 * @property edition SQL Server edition.
 * @property hostType Type of host for Azure Arc SQL Server
 * @property instanceName SQL Server instance name.
 * @property licenseType SQL Server license type.
 * @property patchLevel SQL Server update level.
 * @property productId SQL Server product ID.
 * @property provisioningState The provisioning state of the Arc-enabled SQL Server resource.
 * @property status The cloud connectivity status.
 * @property tcpDynamicPorts Dynamic TCP ports used by SQL Server.
 * @property tcpStaticPorts Static TCP ports used by SQL Server.
 * @property vCore The number of logical processors used by the SQL Server instance.
 * @property version SQL Server version.
 */
public data class SqlServerInstancePropertiesResponse(
    public val azureDefenderStatus: String? = null,
    public val azureDefenderStatusLastUpdated: String? = null,
    public val collation: String? = null,
    public val containerResourceId: String,
    public val cores: String? = null,
    public val createTime: String,
    public val currentVersion: String? = null,
    public val edition: String? = null,
    public val hostType: String? = null,
    public val instanceName: String? = null,
    public val licenseType: String? = null,
    public val patchLevel: String? = null,
    public val productId: String? = null,
    public val provisioningState: String,
    public val status: String,
    public val tcpDynamicPorts: String? = null,
    public val tcpStaticPorts: String? = null,
    public val vCore: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlServerInstancePropertiesResponse):
            SqlServerInstancePropertiesResponse = SqlServerInstancePropertiesResponse(
            azureDefenderStatus = javaType.azureDefenderStatus().map({ args0 -> args0 }).orElse(null),
            azureDefenderStatusLastUpdated = javaType.azureDefenderStatusLastUpdated().map({ args0 ->
                args0
            }).orElse(null),
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            containerResourceId = javaType.containerResourceId(),
            cores = javaType.cores().map({ args0 -> args0 }).orElse(null),
            createTime = javaType.createTime(),
            currentVersion = javaType.currentVersion().map({ args0 -> args0 }).orElse(null),
            edition = javaType.edition().map({ args0 -> args0 }).orElse(null),
            hostType = javaType.hostType().map({ args0 -> args0 }).orElse(null),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            patchLevel = javaType.patchLevel().map({ args0 -> args0 }).orElse(null),
            productId = javaType.productId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            tcpDynamicPorts = javaType.tcpDynamicPorts().map({ args0 -> args0 }).orElse(null),
            tcpStaticPorts = javaType.tcpStaticPorts().map({ args0 -> args0 }).orElse(null),
            vCore = javaType.vCore().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
