@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Service principal for uploading billing, metrics and logs.
 * @property authority Authority for the service principal. Example: https://login.microsoftonline.com/
 * @property clientId Client ID of the service principal for uploading data.
 * @property tenantId Tenant ID of the service principal.
 */
public data class UploadServicePrincipalResponse(
    public val authority: String? = null,
    public val clientId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.UploadServicePrincipalResponse):
            UploadServicePrincipalResponse = UploadServicePrincipalResponse(
            authority = javaType.authority().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
