@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin

import com.pulumi.azurenative.azuredata.AzuredataFunctions.getSqlServerPlain
import com.pulumi.azurenative.azuredata.AzuredataFunctions.getSqlServerRegistrationPlain
import com.pulumi.azurenative.azuredata.kotlin.inputs.GetSqlServerPlainArgs
import com.pulumi.azurenative.azuredata.kotlin.inputs.GetSqlServerPlainArgsBuilder
import com.pulumi.azurenative.azuredata.kotlin.inputs.GetSqlServerRegistrationPlainArgs
import com.pulumi.azurenative.azuredata.kotlin.inputs.GetSqlServerRegistrationPlainArgsBuilder
import com.pulumi.azurenative.azuredata.kotlin.outputs.GetSqlServerRegistrationResult
import com.pulumi.azurenative.azuredata.kotlin.outputs.GetSqlServerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azuredata.kotlin.outputs.GetSqlServerRegistrationResult.Companion.toKotlin as getSqlServerRegistrationResultToKotlin
import com.pulumi.azurenative.azuredata.kotlin.outputs.GetSqlServerResult.Companion.toKotlin as getSqlServerResultToKotlin

public object AzuredataFunctions {
    /**
     * Gets a SQL Server.
     * Azure REST API version: 2019-07-24-preview.
     * @param argument null
     * @return A SQL server.
     */
    public suspend fun getSqlServer(argument: GetSqlServerPlainArgs): GetSqlServerResult =
        getSqlServerResultToKotlin(getSqlServerPlain(argument.toJava()).await())

    /**
     * @see [getSqlServer].
     * @param expand The child resources to include in the response.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlServerName Name of the SQL Server.
     * @param sqlServerRegistrationName Name of the SQL Server registration.
     * @return A SQL server.
     */
    public suspend fun getSqlServer(
        expand: String? = null,
        resourceGroupName: String,
        sqlServerName: String,
        sqlServerRegistrationName: String,
    ): GetSqlServerResult {
        val argument = GetSqlServerPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            sqlServerName = sqlServerName,
            sqlServerRegistrationName = sqlServerRegistrationName,
        )
        return getSqlServerResultToKotlin(getSqlServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredata&#46;kotlin&#46;inputs&#46;GetSqlServerPlainArgs].
     * @return A SQL server.
     */
    public suspend fun getSqlServer(argument: suspend GetSqlServerPlainArgsBuilder.() -> Unit):
        GetSqlServerResult {
        val builder = GetSqlServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerResultToKotlin(getSqlServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a SQL Server registration.
     * Azure REST API version: 2019-07-24-preview.
     * @param argument null
     * @return A SQL server registration.
     */
    public suspend fun getSqlServerRegistration(argument: GetSqlServerRegistrationPlainArgs):
        GetSqlServerRegistrationResult =
        getSqlServerRegistrationResultToKotlin(getSqlServerRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getSqlServerRegistration].
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlServerRegistrationName Name of the SQL Server registration.
     * @return A SQL server registration.
     */
    public suspend fun getSqlServerRegistration(
        resourceGroupName: String,
        sqlServerRegistrationName: String,
    ): GetSqlServerRegistrationResult {
        val argument = GetSqlServerRegistrationPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlServerRegistrationName = sqlServerRegistrationName,
        )
        return getSqlServerRegistrationResultToKotlin(getSqlServerRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlServerRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredata&#46;kotlin&#46;inputs&#46;GetSqlServerRegistrationPlainArgs].
     * @return A SQL server registration.
     */
    public suspend
    fun getSqlServerRegistration(argument: suspend GetSqlServerRegistrationPlainArgsBuilder.() -> Unit):
        GetSqlServerRegistrationResult {
        val builder = GetSqlServerRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlServerRegistrationResultToKotlin(getSqlServerRegistrationPlain(builtArgument.toJava()).await())
    }
}
